/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.screen;

import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.RenderTickable;
import info.u_team.u_team_core.api.gui.TooltipRenderable;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.u_team_core.screen.FluidContainerMenuScreen;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class UContainerMenuScreen<T extends AbstractContainerMenu>
extends FluidContainerMenuScreen<T>
implements PerspectiveRenderable,
TooltipRenderable {
    protected static final RGBA DEFAULT_TEXT_COLOR = new RGBA(0x404040FF);
    protected ResourceLocation background;
    protected int backgroundWidth;
    protected int backgroundHeight;
    protected RGBA backgroundColor;
    protected boolean drawTitleText;
    protected boolean drawInventoryText;
    protected RGBA textColor;

    public UContainerMenuScreen(T menu, Inventory playerInventory, Component title, ResourceLocation background, int imageWidth, int imageHeight) {
        this(menu, playerInventory, title, background);
        this.setImageDimensions(imageWidth, imageHeight);
    }

    public UContainerMenuScreen(T menu, Inventory playerInventory, Component title, ResourceLocation background) {
        super(menu, playerInventory, title);
        this.background = background;
        this.backgroundWidth = 256;
        this.backgroundHeight = 256;
        this.backgroundColor = RGBA.WHITE;
        this.drawTitleText = true;
        this.drawInventoryText = true;
        this.textColor = DEFAULT_TEXT_COLOR;
    }

    protected void setBackground(ResourceLocation background) {
        this.background = background;
    }

    protected void setBackgroundDimensions(int size) {
        this.setBackgroundDimensions(size, size);
    }

    protected void setBackgroundDimensions(int backgroundWidth, int backgroundHeight) {
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    protected void setImageDimensions(int imageWidth, int imageHeight) {
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.setDefaultTextLocation();
    }

    protected void setDrawText(boolean drawTitleText, boolean drawInventoryText) {
        this.drawTitleText = drawTitleText;
        this.drawInventoryText = drawInventoryText;
    }

    protected void setDefaultTextLocation() {
        this.setTextLocation(8, 6, 8, this.imageHeight - 94);
    }

    protected void setTextLocation(int titleLabelX, int titleLabelY, int inventoryLabelX, int inventoryLabelY) {
        this.titleLabelX = titleLabelX;
        this.titleLabelY = titleLabelY;
        this.inventoryLabelX = inventoryLabelX;
        this.inventoryLabelY = inventoryLabelY;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBehind(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void renderBehind(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        if (this.drawTitleText) {
            guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, this.textColor.getColorARGB(), false);
        }
        if (this.drawInventoryText) {
            guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.textColor.getColorARGB(), false);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderUtil.drawTexturedQuad(guiGraphics.pose(), this.leftPos, this.topPos, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, 0.0f, this.background, this.backgroundColor);
    }

    public void containerTick() {
        for (GuiEventListener listener : this.children()) {
            if (!(listener instanceof RenderTickable)) continue;
            RenderTickable tickable = (RenderTickable)listener;
            tickable.renderTick();
        }
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof UContainerMenu) {
            UContainerMenu uMenu = (UContainerMenu)abstractContainerMenu;
            uMenu.broadcastChangesToServer();
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        GuiEventListener focused = this.getFocused();
        if (focused != null && this.isDragging() && button == 0) {
            focused.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }
}

