package net.thomilist.showdurability.mixin.client;

import net.minecraft.class_1799;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_8012;
import net.thomilist.showdurability.ShowDurability;
import net.thomilist.showdurability.access.ShowDurabilityAccess;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin( class_332.class )
public abstract class ShowDurabilityMixin
    implements ShowDurabilityAccess
{
    // The factor used to scale the text size and move it accordingly.
    // A factor of 2 means the text will be half the original size.
    @Unique
    private static final int SCALE_FACTOR = 2;

    @Unique
    boolean isTabIcon = false;

    @Shadow
    public abstract Matrix3x2fStack getMatrices();

    @Shadow
    public abstract void drawText( class_327 textRenderer,
                                   @Nullable String text,
                                   int x,
                                   int y,
                                   int color,
                                   boolean shadow );

    @Override
    public void show_durability$setTabIconState( final boolean isTabIcon )
    {
        this.isTabIcon = isTabIcon;
    }

    @Override
    public boolean show_durability$isTabIcon()
    {
        return this.isTabIcon;
    }

    @Inject( at = @At( "TAIL" ),
             method = "drawStackOverlay(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/item/ItemStack;" +
                      "IILjava/lang/String;)V" )
    public void drawStackOverlay( final class_327 textRenderer,
                                  final class_1799 stack,
                                  final int x,
                                  final int y,
                                  @Nullable final String countOverride,
                                  final CallbackInfo info )
    {
        if ( ShowDurability.CONFIG.getVisibility() && !this.show_durability$isTabIcon() )
        {
            final Matrix3x2fStack matrices = this.getMatrices();
            matrices.pushMatrix();

            if ( (stack.method_7947() == 1) && stack.method_7963() )
            {
                final String durability = String.valueOf( stack.method_7936() - stack.method_7919() );
                matrices.translate( 0.0f, 0.0f );
                matrices.scale( 1.0f / ShowDurabilityMixin.SCALE_FACTOR, 1.0f / ShowDurabilityMixin.SCALE_FACTOR );
                final int textX =
                    ((ShowDurabilityMixin.SCALE_FACTOR * x) + (16 / ShowDurabilityMixin.SCALE_FACTOR) + 5 + 19) - 2 -
                    textRenderer.method_1727( durability );
                final int textY = (ShowDurabilityMixin.SCALE_FACTOR * y) + (16 / ShowDurabilityMixin.SCALE_FACTOR) + 1 +
                                  6 + 3;
                this.drawText( textRenderer, durability, textX, textY, class_8012.field_42973, true );
            }

            matrices.popMatrix();
        }
    }
}
