/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.showdurability;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.thomilist.showdurability.ShowDurability;

@Environment(value=EnvType.CLIENT)
public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path configPath;
    private boolean visible = true;

    public Config() {
        this.configPath = class_310.method_1551().field_1697.toPath().resolve("config").resolve("show-durability.json");
        this.load();
    }

    public void load() {
        try {
            String visibilitySettingJson = Files.readString(this.configPath);
            this.visible = (Boolean)GSON.fromJson(visibilitySettingJson, Boolean.class);
        }
        catch (IOException e) {
            ShowDurability.LOGGER.warn("Failed to read config file", (Throwable)e);
            this.save();
        }
        catch (JsonSyntaxException e) {
            ShowDurability.LOGGER.warn("Invalid JSON syntax in config file", (Throwable)e);
            this.save();
        }
        catch (NullPointerException e) {
            ShowDurability.LOGGER.warn("Config is empty or null", (Throwable)e);
            this.save();
        }
    }

    public void save() {
        try {
            String visibilitySettingJson = GSON.toJson((Object)this.visible);
            Files.writeString(this.configPath, (CharSequence)visibilitySettingJson, new OpenOption[0]);
        }
        catch (IOException e) {
            ShowDurability.LOGGER.error("Unable to write to config file", (Throwable)e);
        }
    }

    public void toggleVisibility() {
        this.visible = !this.visible;
    }

    public boolean getVisibility() {
        return this.visible;
    }
}

