/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.femboypig.flow.chat.ChatManager;
import ru.femboypig.flow.commands.FlowReloadCommand;
import ru.femboypig.flow.commands.IgnoreCommand;
import ru.femboypig.flow.commands.MessageCommand;
import ru.femboypig.flow.commands.ReplyCommand;
import ru.femboypig.flow.commands.SettingsCommand;
import ru.femboypig.flow.gui.SettingsGUI;
import ru.femboypig.flow.listeners.ChatListener;
import ru.femboypig.flow.listeners.PlayerDataListener;
import ru.femboypig.flow.listeners.SettingsGUIListener;
import ru.femboypig.flow.utils.AntiSpamManager;
import ru.femboypig.flow.utils.ChatFilter;
import ru.femboypig.flow.utils.EmojiManager;
import ru.femboypig.flow.utils.IgnoreManager;
import ru.femboypig.flow.utils.MentionManager;
import ru.femboypig.flow.utils.MessagesManager;
import ru.femboypig.flow.utils.PlayerSettingsManager;

public final class Flow
extends JavaPlugin {
    private static Flow instance;
    private ChatManager chatManager;
    private AntiSpamManager antiSpamManager;
    private ChatFilter chatFilter;
    private IgnoreManager ignoreManager;
    private EmojiManager emojiManager;
    private MentionManager mentionManager;
    private PlayerSettingsManager playerSettingsManager;
    private SettingsGUI settingsGUI;
    private MessagesManager messagesManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") == null) {
            this.getLogger().warning("PlaceholderAPI not found! Prefixes won't work!");
            this.getLogger().warning("Download PlaceholderAPI: https://www.spigotmc.org/resources/placeholderapi.6245/");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.messagesManager = new MessagesManager(this);
        this.antiSpamManager = new AntiSpamManager(this);
        this.chatFilter = new ChatFilter(this);
        this.ignoreManager = new IgnoreManager(this);
        this.emojiManager = new EmojiManager(this);
        this.mentionManager = new MentionManager(this);
        this.chatManager = new ChatManager(this);
        this.playerSettingsManager = new PlayerSettingsManager(this);
        this.settingsGUI = new SettingsGUI(this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SettingsGUIListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDataListener(this), (Plugin)this);
        this.getCommand("msg").setExecutor((CommandExecutor)new MessageCommand(this));
        this.getCommand("reply").setExecutor((CommandExecutor)new ReplyCommand(this));
        this.getCommand("flowreload").setExecutor((CommandExecutor)new FlowReloadCommand(this));
        this.getCommand("ignore").setExecutor((CommandExecutor)new IgnoreCommand(this));
        this.getCommand("settings").setExecutor((CommandExecutor)new SettingsCommand(this));
        this.getServer().getOnlinePlayers().forEach(player -> this.playerSettingsManager.loadPlayerSettings((Player)player));
        this.getLogger().info("Flow has been successfully enabled!");
    }

    public void onDisable() {
        this.getServer().getOnlinePlayers().forEach(player -> this.playerSettingsManager.savePlayerSettings((Player)player));
        instance = null;
        this.getLogger().info("Flow has been successfully disabled!");
    }

    public static Flow getInstance() {
        return instance;
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }

    public AntiSpamManager getAntiSpamManager() {
        return this.antiSpamManager;
    }

    public ChatFilter getChatFilter() {
        return this.chatFilter;
    }

    public IgnoreManager getIgnoreManager() {
        return this.ignoreManager;
    }

    public EmojiManager getEmojiManager() {
        return this.emojiManager;
    }

    public MentionManager getMentionManager() {
        return this.mentionManager;
    }

    public PlayerSettingsManager getPlayerSettingsManager() {
        return this.playerSettingsManager;
    }

    public SettingsGUI getSettingsGUI() {
        return this.settingsGUI;
    }

    public MessagesManager getMessagesManager() {
        return this.messagesManager;
    }
}

