/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow.commands;

import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.femboypig.flow.Flow;

public class MessageCommand
implements CommandExecutor {
    private final Flow plugin;

    public MessageCommand(Flow plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessagesManager().getMessage("settings.command-players-only"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getMessagesManager().getMessage("private-messages.usage"));
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.getPlayerSettingsManager().canReceivePrivateMessages(player)) {
            player.sendMessage(this.plugin.getMessagesManager().getMessage("private-messages.disabled-sender"));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage(this.plugin.getMessagesManager().getMessage("private-messages.player-not-found"));
            return true;
        }
        if (target == player) {
            sender.sendMessage(this.plugin.getMessagesManager().getMessage("private-messages.cant-message-self"));
            return true;
        }
        StringBuilder message = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            message.append(args[i]).append(" ");
        }
        this.plugin.getChatManager().sendPrivateMessage(player, target, message.toString().trim());
        return true;
    }
}

