/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import org.bukkit.entity.Player;
import ru.femboypig.flow.Flow;

public class JsonDataManager {
    private final Flow plugin;
    private final File dataFolder;
    private final Gson gson;
    private final Type settingsType;

    public JsonDataManager(Flow plugin) {
        this.plugin = plugin;
        this.dataFolder = new File(plugin.getDataFolder(), "playerdata");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.settingsType = new TypeToken<PlayerSettingsData>(){}.getType();
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
    }

    public void savePlayerSettings(Player player, boolean privateMessagesEnabled, boolean afkStatus, String afkMessage) {
        File playerFile = new File(this.dataFolder, player.getUniqueId().toString() + ".json");
        PlayerSettingsData data = new PlayerSettingsData(privateMessagesEnabled, afkStatus, afkMessage);
        try (FileWriter writer = new FileWriter(playerFile);){
            this.gson.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save settings for player " + player.getName());
            e.printStackTrace();
        }
    }

    public PlayerSettingsData loadPlayerSettings(Player player) {
        PlayerSettingsData playerSettingsData;
        File playerFile = new File(this.dataFolder, player.getUniqueId().toString() + ".json");
        if (!playerFile.exists()) {
            return new PlayerSettingsData(true, false, "I am currently AFK. I will respond when I return.");
        }
        FileReader reader = new FileReader(playerFile);
        try {
            playerSettingsData = (PlayerSettingsData)this.gson.fromJson((Reader)reader, this.settingsType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to load settings for player " + player.getName());
                e.printStackTrace();
                return new PlayerSettingsData(true, false, "I am currently AFK. I will respond when I return.");
            }
        }
        reader.close();
        return playerSettingsData;
    }

    public static class PlayerSettingsData {
        private final boolean privateMessagesEnabled;
        private final boolean afkStatus;
        private final String afkMessage;

        public PlayerSettingsData(boolean privateMessagesEnabled, boolean afkStatus, String afkMessage) {
            this.privateMessagesEnabled = privateMessagesEnabled;
            this.afkStatus = afkStatus;
            this.afkMessage = afkMessage;
        }

        public boolean isPrivateMessagesEnabled() {
            return this.privateMessagesEnabled;
        }

        public boolean isAfkStatus() {
            return this.afkStatus;
        }

        public String getAfkMessage() {
            return this.afkMessage;
        }
    }
}

