/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import ru.femboypig.flow.Flow;

public class IgnoreManager {
    private final Flow plugin;
    private final Map<UUID, Set<UUID>> ignoredPlayers;

    public IgnoreManager(Flow plugin) {
        this.plugin = plugin;
        this.ignoredPlayers = new HashMap<UUID, Set<UUID>>();
    }

    public void ignorePlayer(Player player, Player ignored) {
        UUID playerUUID = player.getUniqueId();
        UUID ignoredUUID = ignored.getUniqueId();
        this.ignoredPlayers.computeIfAbsent(playerUUID, k -> new HashSet()).add(ignoredUUID);
    }

    public void unignorePlayer(Player player, Player ignored) {
        UUID playerUUID = player.getUniqueId();
        UUID ignoredUUID = ignored.getUniqueId();
        if (this.ignoredPlayers.containsKey(playerUUID)) {
            this.ignoredPlayers.get(playerUUID).remove(ignoredUUID);
        }
    }

    public boolean isIgnored(Player sender, Player recipient) {
        return this.ignoredPlayers.containsKey(recipient.getUniqueId()) && this.ignoredPlayers.get(recipient.getUniqueId()).contains(sender.getUniqueId());
    }

    public Set<UUID> getIgnoredPlayers(Player player) {
        return this.ignoredPlayers.getOrDefault(player.getUniqueId(), new HashSet());
    }
}

