/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import ru.femboypig.flow.Flow;

public class MessageFormatter {
    private final Flow plugin;
    private final SimpleDateFormat timeFormat;

    public MessageFormatter(Flow plugin) {
        this.plugin = plugin;
        this.timeFormat = new SimpleDateFormat(plugin.getConfig().getString("time-format", "HH:mm:ss"));
    }

    public TextComponent formatMessage(Player sender, String message, String format) {
        String formattedMessage = format.replace("%player_name%", sender.getName()).replace("%message%", message);
        formattedMessage = PlaceholderAPI.setPlaceholders((Player)sender, (String)formattedMessage);
        formattedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)formattedMessage);
        TextComponent component = new TextComponent(formattedMessage);
        if (this.plugin.getConfig().getBoolean("hover.enabled", true)) {
            component.setHoverEvent(this.createHoverEvent(sender));
        }
        if (this.plugin.getConfig().getBoolean("click.enabled", true)) {
            component.setClickEvent(this.createClickEvent(sender));
        }
        return component;
    }

    private HoverEvent createHoverEvent(Player player) {
        List hoverFormat = this.plugin.getConfig().getStringList("hover.format");
        String hoverText = hoverFormat.stream().map(line -> line.replace("%player_name%", player.getName()).replace("%time%", this.timeFormat.format(new Date())).replace("%player_ping%", String.valueOf(player.getPing()))).map(line -> PlaceholderAPI.setPlaceholders((Player)player, (String)line)).map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).collect(Collectors.joining("\n"));
        return new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hoverText).create());
    }

    private ClickEvent createClickEvent(Player player) {
        String action = this.plugin.getConfig().getString("click.action", "SUGGEST_COMMAND");
        String value = this.plugin.getConfig().getString("click.value", "/msg %player_name% ").replace("%player_name%", player.getName());
        return new ClickEvent(ClickEvent.Action.valueOf((String)action), value);
    }
}

