/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow.utils;

import java.io.File;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import ru.femboypig.flow.Flow;

public class MessagesManager {
    private final Flow plugin;
    private FileConfiguration messages;

    public MessagesManager(Flow plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public void loadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    public String getMessage(String path) {
        String message = this.messages.getString("messages." + path);
        return message == null ? "Message not found: " + path : ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getMessage(String path, String ... placeholders) {
        String message = this.getMessage(path);
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            message = message.replace(placeholders[i], placeholders[i + 1]);
        }
        return message;
    }
}

