/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import ru.femboypig.flow.Flow;
import ru.femboypig.flow.data.JsonDataManager;

public class PlayerSettingsManager {
    private final Flow plugin;
    private final Map<UUID, PlayerSettings> playerSettings;
    private final Map<UUID, Boolean> afkStatus;
    private final JsonDataManager dataManager;

    public PlayerSettingsManager(Flow plugin) {
        this.plugin = plugin;
        this.playerSettings = new HashMap<UUID, PlayerSettings>();
        this.afkStatus = new HashMap<UUID, Boolean>();
        this.dataManager = new JsonDataManager(plugin);
    }

    public void loadPlayerSettings(Player player) {
        UUID uuid = player.getUniqueId();
        JsonDataManager.PlayerSettingsData data = this.dataManager.loadPlayerSettings(player);
        PlayerSettings settings = new PlayerSettings();
        settings.setPrivateMessagesEnabled(data.isPrivateMessagesEnabled());
        settings.setAfkMessage(data.getAfkMessage());
        this.playerSettings.put(uuid, settings);
        this.afkStatus.put(uuid, data.isAfkStatus());
    }

    public void savePlayerSettings(Player player) {
        PlayerSettings settings = this.getPlayerSettings(player);
        boolean isAfk = this.isAfk(player);
        this.dataManager.savePlayerSettings(player, settings.isPrivateMessagesEnabled(), isAfk, settings.getAfkMessage());
    }

    public boolean canReceivePrivateMessages(Player player) {
        return this.getPlayerSettings(player).isPrivateMessagesEnabled();
    }

    public void setPrivateMessagesEnabled(Player player, boolean enabled) {
        this.getPlayerSettings(player).setPrivateMessagesEnabled(enabled);
        this.savePlayerSettings(player);
    }

    public boolean isAfk(Player player) {
        return this.afkStatus.getOrDefault(player.getUniqueId(), false);
    }

    public void setAfk(Player player, boolean afk) {
        this.afkStatus.put(player.getUniqueId(), afk);
        this.savePlayerSettings(player);
    }

    public String getAfkMessage(Player player) {
        return this.getPlayerSettings(player).getAfkMessage();
    }

    public void setAfkMessage(Player player, String message) {
        this.getPlayerSettings(player).setAfkMessage(message);
        this.savePlayerSettings(player);
    }

    private PlayerSettings getPlayerSettings(Player player) {
        return this.playerSettings.computeIfAbsent(player.getUniqueId(), k -> {
            this.loadPlayerSettings(player);
            return this.playerSettings.get(k);
        });
    }

    private static class PlayerSettings {
        private boolean privateMessagesEnabled = true;
        private String afkMessage = "I am currently AFK. I will respond when I return.";

        private PlayerSettings() {
        }

        public boolean isPrivateMessagesEnabled() {
            return this.privateMessagesEnabled;
        }

        public void setPrivateMessagesEnabled(boolean enabled) {
            this.privateMessagesEnabled = enabled;
        }

        public String getAfkMessage() {
            return this.afkMessage;
        }

        public void setAfkMessage(String message) {
            this.afkMessage = message;
        }
    }
}

