/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow.utils;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import ru.femboypig.flow.Flow;

public class EmojiManager {
    private final Flow plugin;
    private final Map<String, String> emojis;

    public EmojiManager(Flow plugin) {
        this.plugin = plugin;
        this.emojis = new HashMap<String, String>();
        this.loadEmojis();
    }

    private void loadEmojis() {
        for (String key : this.plugin.getConfig().getConfigurationSection("emojis").getKeys(false)) {
            this.emojis.put(key, this.plugin.getConfig().getString("emojis." + key));
        }
    }

    public String replaceEmojis(String message, Player player) {
        if (!player.hasPermission("flow.emojis")) {
            return message;
        }
        String result = message;
        for (Map.Entry<String, String> emoji : this.emojis.entrySet()) {
            result = result.replace(emoji.getKey(), emoji.getValue());
        }
        return result;
    }
}

