/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow.utils;

import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import ru.femboypig.flow.Flow;

public class MentionManager {
    private final Flow plugin;

    public MentionManager(Flow plugin) {
        this.plugin = plugin;
    }

    public String processMentions(String message, Player sender) {
        String processedMessage = message;
        for (Player player : Bukkit.getOnlinePlayers()) {
            String mention = "@" + player.getName();
            if (!message.contains(mention)) continue;
            processedMessage = processedMessage.replace(mention, this.plugin.getConfig().getString("mentions.format", "&e@%player%&r").replace("%player%", player.getName()));
            if (!player.isOnline() || player.equals(sender)) continue;
            this.notifyPlayer(player, sender);
        }
        return processedMessage;
    }

    private void notifyPlayer(Player mentioned, Player sender) {
        if (this.plugin.getConfig().getBoolean("mentions.sound.enabled", true)) {
            String soundName = this.plugin.getConfig().getString("mentions.sound.type", "ENTITY_EXPERIENCE_ORB_PICKUP");
            float volume = (float)this.plugin.getConfig().getDouble("mentions.sound.volume", 1.0);
            float pitch = (float)this.plugin.getConfig().getDouble("mentions.sound.pitch", 1.0);
            mentioned.playSound(mentioned.getLocation(), Sound.valueOf((String)soundName), volume, pitch);
        }
        if (this.plugin.getConfig().getBoolean("mentions.title.enabled", true)) {
            String title = this.plugin.getConfig().getString("mentions.title.text", "&eMention from %player%").replace("%player%", sender.getName());
            mentioned.sendTitle("", title, 10, 40, 10);
        }
    }
}

