/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow.chat;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import ru.femboypig.flow.Flow;
import ru.femboypig.flow.utils.MessageFormatter;

public class ChatManager {
    private final Flow plugin;
    private final Map<UUID, UUID> lastMessageSender;
    private final MessageFormatter formatter;
    private int localChatRadius;
    private String globalChatPrefix;
    private String localFormat;
    private String globalFormat;
    private String privateOutgoingFormat;
    private String privateIncomingFormat;

    public ChatManager(Flow plugin) {
        this.plugin = plugin;
        this.lastMessageSender = new HashMap<UUID, UUID>();
        this.formatter = new MessageFormatter(plugin);
        this.loadConfig();
    }

    public void loadConfig() {
        this.localChatRadius = this.plugin.getConfig().getInt("local-chat-radius", 100);
        this.globalChatPrefix = this.plugin.getConfig().getString("global-chat-prefix", "!");
        this.localFormat = this.plugin.getConfig().getString("format.local", "%luckperms_prefix%%player_name% &8\u2192 &f%message%");
        this.globalFormat = this.plugin.getConfig().getString("format.global", "&6[G] %luckperms_prefix%%player_name% &8\u2192 &f%message%");
        this.privateOutgoingFormat = this.plugin.getConfig().getString("format.private.outgoing", "&d\u2192 &7%recipient%&8: &f%message%");
        this.privateIncomingFormat = this.plugin.getConfig().getString("format.private.incoming", "&dFrom &7%sender%&8: &f%message%");
    }

    public void handleChat(Player sender, String message) {
        if (this.plugin.getAntiSpamManager().isSpamming(sender)) {
            sender.sendMessage(this.plugin.getMessagesManager().getMessage("errors.spam-warning"));
            return;
        }
        if (this.plugin.getChatFilter().containsBannedWords(message) && !sender.hasPermission("flow.bypass.filter")) {
            sender.sendMessage(this.plugin.getMessagesManager().getMessage("errors.banned-words"));
            return;
        }
        String processedMessage = message;
        if (!sender.hasPermission("flow.bypass.filter")) {
            processedMessage = this.plugin.getChatFilter().filterMessage(processedMessage);
        }
        processedMessage = this.plugin.getEmojiManager().replaceEmojis(processedMessage, sender);
        processedMessage = this.plugin.getMentionManager().processMentions(processedMessage, sender);
        if (processedMessage.startsWith(this.globalChatPrefix)) {
            this.sendGlobalMessage(sender, processedMessage.substring(this.globalChatPrefix.length()).trim());
        } else {
            this.sendLocalMessage(sender, processedMessage);
        }
    }

    public void sendLocalMessage(Player sender, String message) {
        TextComponent component = this.formatter.formatMessage(sender, message, this.localFormat);
        sender.getNearbyEntities((double)this.localChatRadius, (double)this.localChatRadius, (double)this.localChatRadius).stream().filter(entity -> entity instanceof Player).map(entity -> (Player)entity).filter(player -> !this.plugin.getIgnoreManager().isIgnored(sender, (Player)player)).forEach(player -> player.spigot().sendMessage((BaseComponent)component));
        sender.spigot().sendMessage((BaseComponent)component);
    }

    public void sendGlobalMessage(Player sender, String message) {
        TextComponent component = this.formatter.formatMessage(sender, message, this.globalFormat);
        this.plugin.getServer().getOnlinePlayers().stream().filter(player -> !this.plugin.getIgnoreManager().isIgnored(sender, (Player)player)).forEach(player -> player.spigot().sendMessage((BaseComponent)component));
    }

    public void sendPrivateMessage(Player sender, Player recipient, String message) {
        if (this.plugin.getIgnoreManager().isIgnored(sender, recipient)) {
            sender.sendMessage(this.plugin.getMessagesManager().getMessage("private-messages.player-ignoring"));
            return;
        }
        if (!this.plugin.getPlayerSettingsManager().canReceivePrivateMessages(recipient)) {
            sender.sendMessage(this.plugin.getMessagesManager().getMessage("private-messages.disabled-recipient"));
            return;
        }
        if (this.plugin.getPlayerSettingsManager().isAfk(recipient)) {
            String afkMessage = this.plugin.getPlayerSettingsManager().getAfkMessage(recipient);
            sender.sendMessage(this.plugin.getMessagesManager().getMessage("settings.player-afk", "%player%", recipient.getName(), "%message%", afkMessage));
        }
        TextComponent outgoingComponent = this.formatter.formatMessage(sender, message, this.privateOutgoingFormat.replace("%recipient%", recipient.getName()));
        TextComponent incomingComponent = this.formatter.formatMessage(sender, message, this.privateIncomingFormat.replace("%sender%", sender.getName()));
        sender.spigot().sendMessage((BaseComponent)outgoingComponent);
        recipient.spigot().sendMessage((BaseComponent)incomingComponent);
        this.lastMessageSender.put(recipient.getUniqueId(), sender.getUniqueId());
    }

    public UUID getLastMessageSender(Player player) {
        return this.lastMessageSender.get(player.getUniqueId());
    }
}

