/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow.gui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ru.femboypig.flow.Flow;

public class SettingsGUI {
    private final Flow plugin;
    private static final String GUI_TITLE = "Player Settings";

    public SettingsGUI(Flow plugin) {
        this.plugin = plugin;
    }

    public void openSettings(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (int)27, (String)GUI_TITLE);
        boolean pmEnabled = this.plugin.getPlayerSettingsManager().canReceivePrivateMessages(player);
        inventory.setItem(11, this.createToggleItem(Material.PAPER, "Private Messages", pmEnabled, "Click to " + (pmEnabled ? "disable" : "enable") + " private messages"));
        boolean isAfk = this.plugin.getPlayerSettingsManager().isAfk(player);
        inventory.setItem(13, this.createToggleItem(Material.CLOCK, "AFK Status", isAfk, "Click to " + (isAfk ? "disable" : "enable") + " AFK status"));
        inventory.setItem(15, this.createItem(Material.BOOK, "AFK Message", "Current: " + this.plugin.getPlayerSettingsManager().getAfkMessage(player), "Click to change your AFK message"));
        player.openInventory(inventory);
    }

    private ItemStack createToggleItem(Material material, String name, boolean enabled, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColor.YELLOW + name + ": " + (enabled ? ChatColor.GREEN + "Enabled" : ChatColor.RED + "Disabled"));
        ArrayList<CallSite> loreList = new ArrayList<CallSite>();
        for (String line : lore) {
            loreList.add((CallSite)((Object)(ChatColor.GRAY + line)));
        }
        meta.setLore(loreList);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColor.YELLOW + name);
        ArrayList<CallSite> loreList = new ArrayList<CallSite>();
        for (String line : lore) {
            loreList.add((CallSite)((Object)(ChatColor.GRAY + line)));
        }
        meta.setLore(loreList);
        item.setItemMeta(meta);
        return item;
    }
}

