/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import ru.femboypig.flow.Flow;

public class SettingsGUIListener
implements Listener {
    private final Flow plugin;
    private final Map<UUID, SettingsState> playerStates;

    public SettingsGUIListener(Flow plugin) {
        this.plugin = plugin;
        this.playerStates = new HashMap<UUID, SettingsState>();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!event.getView().getTitle().equals("Player Settings")) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        String itemName = clickedItem.getItemMeta().getDisplayName();
        if (itemName.contains("Private Messages")) {
            boolean currentState = this.plugin.getPlayerSettingsManager().canReceivePrivateMessages(player);
            this.plugin.getPlayerSettingsManager().setPrivateMessagesEnabled(player, !currentState);
            player.sendMessage(this.plugin.getMessagesManager().getMessage(!currentState ? "settings.private-messages-enabled" : "settings.private-messages-disabled"));
            player.closeInventory();
        } else if (itemName.contains("AFK Status")) {
            boolean currentState = this.plugin.getPlayerSettingsManager().isAfk(player);
            this.plugin.getPlayerSettingsManager().setAfk(player, !currentState);
            player.sendMessage(this.plugin.getMessagesManager().getMessage(!currentState ? "settings.afk-enabled" : "settings.afk-disabled"));
            player.closeInventory();
        } else if (itemName.contains("AFK Message")) {
            player.closeInventory();
            player.sendMessage(this.plugin.getMessagesManager().getMessage("settings.afk-message-prompt"));
            this.playerStates.put(player.getUniqueId(), SettingsState.SETTING_AFK_MESSAGE);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.playerStates.containsKey(player.getUniqueId())) {
            event.setCancelled(true);
            if (this.playerStates.get(player.getUniqueId()) == SettingsState.SETTING_AFK_MESSAGE) {
                this.plugin.getPlayerSettingsManager().setAfkMessage(player, event.getMessage());
                player.sendMessage(this.plugin.getMessagesManager().getMessage("settings.afk-message-updated"));
                this.playerStates.remove(player.getUniqueId());
            }
        }
    }

    private static enum SettingsState {
        SETTING_AFK_MESSAGE;

    }
}

