/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import ru.femboypig.flow.Flow;

public class AntiSpamManager {
    private final Flow plugin;
    private final Map<UUID, Long> lastMessageTime;
    private final Map<UUID, Integer> messageCount;
    private final int cooldownSeconds;
    private final int maxMessages;
    private final int timeWindowSeconds;

    public AntiSpamManager(Flow plugin) {
        this.plugin = plugin;
        this.lastMessageTime = new HashMap<UUID, Long>();
        this.messageCount = new HashMap<UUID, Integer>();
        this.cooldownSeconds = plugin.getConfig().getInt("anti-spam.cooldown", 2);
        this.maxMessages = plugin.getConfig().getInt("anti-spam.max-messages", 5);
        this.timeWindowSeconds = plugin.getConfig().getInt("anti-spam.time-window", 10);
    }

    public boolean isSpamming(Player player) {
        long timeDiff;
        if (player.hasPermission("flow.bypass.antispam")) {
            return false;
        }
        UUID uuid = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.lastMessageTime.containsKey(uuid) && (timeDiff = currentTime - this.lastMessageTime.get(uuid)) < (long)(this.cooldownSeconds * 1000)) {
            return true;
        }
        this.messageCount.putIfAbsent(uuid, 0);
        this.messageCount.put(uuid, this.messageCount.get(uuid) + 1);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.messageCount.put(uuid, this.messageCount.get(uuid) - 1), (long)this.timeWindowSeconds * 20L);
        if (this.messageCount.get(uuid) > this.maxMessages) {
            return true;
        }
        this.lastMessageTime.put(uuid, currentTime);
        return false;
    }
}

