/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import ru.femboypig.flow.Flow;

public class ChatFilter {
    private final Set<String> bannedWords;
    private final Flow plugin;
    private final Pattern pattern;

    public ChatFilter(Flow plugin) {
        this.plugin = plugin;
        this.bannedWords = new HashSet<String>(plugin.getConfig().getStringList("chat-filter.banned-words"));
        this.pattern = Pattern.compile(String.join((CharSequence)"|", this.bannedWords), 2);
    }

    public String filterMessage(String message) {
        if (this.bannedWords.isEmpty()) {
            return message;
        }
        String filtered = message;
        for (String word : this.bannedWords) {
            String replacement = "*".repeat(word.length());
            filtered = filtered.replaceAll("(?i)" + Pattern.quote(word), replacement);
        }
        return filtered;
    }

    public boolean containsBannedWords(String message) {
        return this.pattern.matcher(message).find();
    }
}

