/*
 * Decompiled with CFR 0.152.
 */
package ru.femboypig.flow;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.femboypig.flow.chat.ChatManager;
import ru.femboypig.flow.commands.FlowReloadCommand;
import ru.femboypig.flow.commands.MessageCommand;
import ru.femboypig.flow.commands.ReplyCommand;
import ru.femboypig.flow.listeners.ChatListener;

public final class Flow
extends JavaPlugin {
    private static Flow instance;
    private ChatManager chatManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") == null) {
            this.getLogger().warning("PlaceholderAPI not found! Prefixes won't work!");
            this.getLogger().warning("Download PlaceholderAPI: https://www.spigotmc.org/resources/placeholderapi.6245/");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.chatManager = new ChatManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        this.getCommand("msg").setExecutor((CommandExecutor)new MessageCommand(this));
        this.getCommand("reply").setExecutor((CommandExecutor)new ReplyCommand(this));
        this.getCommand("flowreload").setExecutor((CommandExecutor)new FlowReloadCommand(this));
        this.getLogger().info("Flow has been successfully enabled!");
    }

    public void onDisable() {
        instance = null;
        this.getLogger().info("Flow has been successfully disabled!");
    }

    public static Flow getInstance() {
        return instance;
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }
}

