/*
 * Decompiled with CFR 0.152.
 */
package niv.heater;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_10804;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2446;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_5321;
import net.minecraft.class_5955;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_807;
import net.minecraft.class_8790;
import niv.heater.block.HeatPipeBlock;
import niv.heater.block.HeaterBlock;
import niv.heater.block.ThermostatBlock;
import niv.heater.block.WeatheringHeatPipeBlock;
import niv.heater.block.WeatheringHeaterBlock;
import niv.heater.block.WeatheringThermostatBlock;
import niv.heater.registry.HeaterBlocks;
import niv.heater.registry.HeaterTabs;
import niv.heater.util.WeatherStateExtra;

@Environment(value=EnvType.CLIENT)
public class HeaterDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        HeaterBlocks.initialize();
        HeaterTabs.initialize();
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(HeaterModelProvider::new);
        pack.addProvider(HeaterEnglishLanguageProvider::new);
        pack.addProvider(HeaterLootTableProvider::new);
        pack.addProvider(HeaterRecipeProvider::new);
        pack.addProvider(HeaterTagProvider::new);
    }

    @Environment(value=EnvType.CLIENT)
    private static class HeaterTagProvider
    extends FabricTagProvider.BlockTagProvider {
        public HeaterTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 lookup) {
            this.builder(class_3481.field_33715).method_71557(this.getResourceKeys((Collection<? extends class_2248>)HeaterBlocks.HEATERS.values())).method_71557(this.getResourceKeys((Collection<? extends class_2248>)HeaterBlocks.WAXED_HEATERS.values())).method_71557(this.getResourceKeys((Collection<? extends class_2248>)HeaterBlocks.HEAT_PIPES.values())).method_71557(this.getResourceKeys((Collection<? extends class_2248>)HeaterBlocks.WAXED_HEAT_PIPES.values())).method_71557(this.getResourceKeys((Collection<? extends class_2248>)HeaterBlocks.THERMOSTATS.values())).method_71557(this.getResourceKeys((Collection<? extends class_2248>)HeaterBlocks.WAXED_THERMOSTATS.values())).setReplace(false);
        }

        private Stream<class_5321<class_2248>> getResourceKeys(Collection<? extends class_2248> blocks) {
            return blocks.stream().map(arg_0 -> ((class_7922)class_7923.field_41175).method_29113(arg_0)).flatMap(Optional::stream);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class HeaterRecipeProvider
    extends FabricRecipeProvider {
        private HeaterRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public String method_10321() {
            return "HeaterRecipeProvider";
        }

        protected class_2446 method_62766(class_7225.class_7874 provider, class_8790 exporter) {
            return new class_2446(this, provider, exporter){

                public void method_10419() {
                    this.method_62746(class_7800.field_40642, (class_1935)HeaterBlocks.HEATER).method_10439("ccc").method_10439("cfc").method_10439("ccc").method_10434(Character.valueOf('c'), (class_1935)class_1802.field_27022).method_10434(Character.valueOf('f'), (class_1935)class_1802.field_8732).method_10429(1.method_32807((class_1935)class_1802.field_27022), this.method_10426((class_1935)class_1802.field_27022)).method_10429(1.method_32807((class_1935)class_1802.field_8732), this.method_10426((class_1935)class_1802.field_8732)).method_10431(this.field_53721);
                    for (class_5955.class_5811 state : class_5955.class_5811.values()) {
                        this.generateWaxingRecipe(this.field_53721, ((WeatheringHeaterBlock)HeaterBlocks.HEATERS.get((Object)state)).method_8389(), ((HeaterBlock)HeaterBlocks.WAXED_HEATERS.get((Object)state)).method_8389());
                    }
                    this.method_62746(class_7800.field_40642, (class_1935)HeaterBlocks.HEAT_PIPE).method_10439("ccc").method_10434(Character.valueOf('c'), (class_1935)class_1802.field_27022).method_10429(1.method_32807((class_1935)class_1802.field_27022), this.method_10426((class_1935)class_1802.field_27022)).method_10431(this.field_53721);
                    for (class_5955.class_5811 state : class_5955.class_5811.values()) {
                        this.generateWaxingRecipe(this.field_53721, ((WeatheringHeatPipeBlock)HeaterBlocks.HEAT_PIPES.get((Object)state)).method_8389(), ((HeatPipeBlock)HeaterBlocks.WAXED_HEAT_PIPES.get((Object)state)).method_8389());
                    }
                    this.method_62746(class_7800.field_40642, (class_1935)HeaterBlocks.THERMOSTAT).method_10439("ccc").method_10439("#c#").method_10439("#r#").method_10434(Character.valueOf('c'), (class_1935)class_1802.field_27022).method_10434(Character.valueOf('r'), (class_1935)class_1802.field_8725).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_20412).method_10429(1.method_32807((class_1935)class_1802.field_20412), this.method_10426((class_1935)class_1802.field_20412)).method_10429(1.method_32807((class_1935)class_1802.field_27022), this.method_10426((class_1935)class_1802.field_27022)).method_10429(1.method_32807((class_1935)class_1802.field_8725), this.method_10426((class_1935)class_1802.field_8725)).method_10431(this.field_53721);
                    for (class_5955.class_5811 state : class_5955.class_5811.values()) {
                        this.generateWaxingRecipe(this.field_53721, ((WeatheringThermostatBlock)HeaterBlocks.THERMOSTATS.get((Object)state)).method_8389(), ((ThermostatBlock)HeaterBlocks.WAXED_THERMOSTATS.get((Object)state)).method_8389());
                    }
                }

                private void generateWaxingRecipe(class_8790 output, class_1792 unwaxed, class_1792 waxed) {
                    this.method_62749(class_7800.field_40642, (class_1935)waxed).method_10454((class_1935)unwaxed).method_10454((class_1935)class_1802.field_20414).method_10442(1.method_32807((class_1935)unwaxed), this.method_10426((class_1935)unwaxed)).method_10442(1.method_32807((class_1935)class_1802.field_20414), this.method_10426((class_1935)class_1802.field_20414)).method_10431(output);
                }
            };
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class HeaterLootTableProvider
    extends FabricBlockLootTableProvider {
        private HeaterLootTableProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void method_10379() {
            HeaterBlocks.HEATERS.values().forEach(block -> this.method_45994((class_2248)block, arg_0 -> ((HeaterLootTableProvider)this).method_45996(arg_0)));
            HeaterBlocks.WAXED_HEATERS.values().forEach(block -> this.method_45994((class_2248)block, arg_0 -> ((HeaterLootTableProvider)this).method_45996(arg_0)));
            HeaterBlocks.THERMOSTATS.values().forEach(arg_0 -> ((HeaterLootTableProvider)this).method_46025(arg_0));
            HeaterBlocks.WAXED_THERMOSTATS.values().forEach(arg_0 -> ((HeaterLootTableProvider)this).method_46025(arg_0));
            HeaterBlocks.HEAT_PIPES.values().forEach(arg_0 -> ((HeaterLootTableProvider)this).method_46025(arg_0));
            HeaterBlocks.WAXED_HEAT_PIPES.values().forEach(arg_0 -> ((HeaterLootTableProvider)this).method_46025(arg_0));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class HeaterEnglishLanguageProvider
    extends FabricLanguageProvider {
        private HeaterEnglishLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder builder) {
            this.addAll(builder, "Heater", arg_0 -> HeaterBlocks.WAXED_HEATERS.get(arg_0), arg_0 -> HeaterBlocks.HEATERS.get(arg_0));
            this.addAll(builder, "Heat Pipe", arg_0 -> HeaterBlocks.WAXED_HEAT_PIPES.get(arg_0), arg_0 -> HeaterBlocks.HEAT_PIPES.get(arg_0));
            this.addAll(builder, "Thermostat", arg_0 -> HeaterBlocks.WAXED_THERMOSTATS.get(arg_0), arg_0 -> HeaterBlocks.THERMOSTATS.get(arg_0));
            builder.add("container.heater", "Heater");
            builder.add(HeaterTabs.TAB_NAME, "Heater");
        }

        private void addAll(FabricLanguageProvider.TranslationBuilder translationBuilder, String name, Function<class_5955.class_5811, class_2248> blocks, Function<class_5955.class_5811, class_2248> weatheringBlocks) {
            for (class_5955.class_5811 state : class_5955.class_5811.values()) {
                String value = WeatherStateExtra.toName(state) + name;
                translationBuilder.add(weatheringBlocks.apply(state), value);
                translationBuilder.add(blocks.apply(state), "Waxed " + value);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class HeaterModelProvider
    extends FabricModelProvider {
        private static final class_4926<class_10804> ROTATION_FACING = class_4926.method_67869((class_2769)class_2741.field_12525).method_25794((Comparable)class_2350.field_11033, (Object)class_4910.field_56782).method_25794((Comparable)class_2350.field_11036, (Object)class_4910.field_56784).method_25794((Comparable)class_2350.field_11043, (Object)class_4910.field_56780).method_25794((Comparable)class_2350.field_11035, (Object)class_4910.field_56786).method_25794((Comparable)class_2350.field_11039, (Object)class_4910.field_56787).method_25794((Comparable)class_2350.field_11034, (Object)class_4910.field_56785);
        private static final class_4926<class_10804> ROTATION_HORIZONTAL_FACING = class_4926.method_67869((class_2769)class_2741.field_12481).method_25794((Comparable)class_2350.field_11034, (Object)class_4910.field_56785).method_25794((Comparable)class_2350.field_11035, (Object)class_4910.field_56786).method_25794((Comparable)class_2350.field_11039, (Object)class_4910.field_56787).method_25794((Comparable)class_2350.field_11043, (Object)class_4910.field_56780);
        private static final class_4946.class_4947 THERMOSTAT = class_4946.method_25918(HeaterModelProvider::orientableFullTilt, (class_4942)HeaterModelTemplates.THERMOSTAT);
        private static final class_4946.class_4947 PIPE_CORE = class_4946.method_25918(HeaterModelProvider::pipeCore, (class_4942)HeaterModelTemplates.PIPE_CORE);
        private static final class_4946.class_4947 PIPE_ARM = class_4946.method_25918(HeaterModelProvider::pipeArm, (class_4942)HeaterModelTemplates.PIPE_ARM);

        public HeaterModelProvider(FabricDataOutput output) {
            super(output);
        }

        public String method_10321() {
            return "Heater Block Provider";
        }

        public void generateBlockStateModels(class_4910 generator) {
            for (class_5955.class_5811 weathering : class_5955.class_5811.values()) {
                HeaterModelProvider.createWaxingFurnace(generator, (class_2248)HeaterBlocks.HEATERS.get((Object)weathering), (class_2248)HeaterBlocks.WAXED_HEATERS.get((Object)weathering));
                HeaterModelProvider.createWaxingOrientable(generator, (class_2248)HeaterBlocks.THERMOSTATS.get((Object)weathering), (class_2248)HeaterBlocks.WAXED_THERMOSTATS.get((Object)weathering));
                HeaterModelProvider.createWaxingPipe(generator, (class_2248)HeaterBlocks.HEAT_PIPES.get((Object)weathering), (class_2248)HeaterBlocks.WAXED_HEAT_PIPES.get((Object)weathering));
            }
        }

        public void generateItemModels(class_4915 generator) {
        }

        private static final void createWaxingFurnace(class_4910 generator, class_2248 block, class_2248 waxed) {
            class_4946.class_4947 provider = class_4946.field_23042;
            class_807 unlit = class_4910.method_67835((class_2960)provider.method_25923(block, generator.field_22831));
            class_807 lit = class_4910.method_67835((class_2960)provider.get(block).method_25917(mapping -> mapping.method_25868(class_4945.field_23016, class_4944.method_25866((class_2248)block, (String)"_front_on"))).method_25915(block, "_on", generator.field_22831));
            generator.field_22830.accept(class_4925.method_67852((class_2248)block).method_67859(class_4910.method_25565((class_2746)class_2741.field_12548, (class_807)lit, (class_807)unlit)).method_25775(ROTATION_HORIZONTAL_FACING));
            generator.field_22830.accept(class_4925.method_67852((class_2248)waxed).method_67859(class_4910.method_25565((class_2746)class_2741.field_12548, (class_807)lit, (class_807)unlit)).method_25775(ROTATION_HORIZONTAL_FACING));
            generator.field_55238.method_65459(block.method_8389(), waxed.method_8389());
        }

        private static final void createWaxingOrientable(class_4910 generator, class_2248 block, class_2248 waxed) {
            class_2960 model = THERMOSTAT.method_25923(block, generator.field_22831);
            class_807 variant = class_4910.method_67835((class_2960)model);
            generator.field_22830.accept(class_4925.method_67853((class_2248)block, (class_807)variant).method_25775(ROTATION_FACING));
            generator.field_22830.accept(class_4925.method_67853((class_2248)waxed, (class_807)variant).method_25775(ROTATION_FACING));
            generator.method_25623(block, model);
            generator.method_25623(waxed, model);
        }

        private static final void createWaxingPipe(class_4910 generator, class_2248 block, class_2248 waxed) {
            class_2960 core = PIPE_CORE.method_25923(block, generator.field_22831);
            class_2960 arm = PIPE_ARM.method_25923(block, generator.field_22831);
            class_807 coreVariant = class_4910.method_67835((class_2960)core);
            class_807 armVariant = class_4910.method_67835((class_2960)arm);
            generator.field_22830.accept(class_4922.method_25758((class_2248)block).method_25764(coreVariant).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), armVariant).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), armVariant.method_67929(class_4910.field_56785)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), armVariant.method_67929(class_4910.field_56786)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), armVariant.method_67929(class_4910.field_56787)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12546, (Comparable)Boolean.valueOf(true)), armVariant.method_67929(class_4910.field_56782)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(true)), armVariant.method_67929(class_4910.field_56784)));
            generator.field_22830.accept(class_4922.method_25758((class_2248)waxed).method_25764(coreVariant).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), armVariant).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), armVariant.method_67929(class_4910.field_56785)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), armVariant.method_67929(class_4910.field_56786)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), armVariant.method_67929(class_4910.field_56787)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12546, (Comparable)Boolean.valueOf(true)), armVariant.method_67929(class_4910.field_56782)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(true)), armVariant.method_67929(class_4910.field_56784)));
            generator.method_25623(block, core);
            generator.method_25623(waxed, core);
        }

        private static class_4944 orientableFullTilt(class_2248 block) {
            return new class_4944().method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)block, (String)"_top")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)block, (String)"_bottom"));
        }

        private static class_4944 pipeCore(class_2248 block) {
            return new class_4944().method_25868(class_4945.field_23011, class_4944.method_25860((class_2248)block));
        }

        private static class_4944 pipeArm(class_2248 block) {
            return new class_4944().method_25868(class_4945.field_23011, class_4944.method_25860((class_2248)block));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class HeaterModelTemplates {
        public static final class_4942 THERMOSTAT = HeaterModelTemplates.create("template_thermostat", null, class_4945.field_23015, class_4945.field_23018, class_4945.field_23014);
        public static final class_4942 PIPE_CORE = HeaterModelTemplates.create("pipe_core", "_core", class_4945.field_23011);
        public static final class_4942 PIPE_ARM = HeaterModelTemplates.create("pipe_arm", "_arm", class_4945.field_23011);

        private HeaterModelTemplates() {
        }

        private static class_4942 create(String template, String suffix, class_4945 ... textureSlots) {
            return new class_4942(Optional.of(class_2960.method_60655((String)"heater", (String)("block/" + template))), Optional.ofNullable(suffix), textureSlots);
        }
    }
}

