/*
 * Decompiled with CFR 0.152.
 */
package niv.heater.block.entity;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1273;
import net.minecraft.class_1275;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_8824;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import niv.burning.api.Burning;
import niv.burning.api.BurningContext;
import niv.burning.api.BurningStorage;
import niv.burning.api.BurningStorageHelper;
import niv.burning.api.BurningStorageListener;
import niv.burning.api.base.SimpleBurningStorage;
import niv.burning.impl.FuelValuesBurningContext;
import niv.heater.block.HeaterBlock;
import niv.heater.registry.HeaterBlockEntityTypes;
import niv.heater.screen.HeaterMenu;
import niv.heater.util.Explorer;
import niv.heater.util.WeatherStateExtra;
import org.jetbrains.annotations.Nullable;

public class HeaterBlockEntity
extends class_2586
implements BurningStorageListener,
class_1265,
class_3908,
class_1275,
class_1278 {
    public static final String CONTAINER_NAME = "container.heater";
    public static final int BURN_TIME_PROPERTY_INDEX = 0;
    public static final int FUEL_TIME_PROPERTY_INDEX = 1;
    private static final String CUSTOM_NAME_TAG = "CustomName";
    private static final String ITEM_TAG = "Item";
    private static final String BURNING_TAG = "Burning";
    private static final int[] SLOTS = new int[]{0};
    private static final int MAX_HOPS = 64;
    private final class_3913 burningData = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return HeaterBlockEntity.this.burningStorage.getCurrentBurning();
                }
                case 1: {
                    return HeaterBlockEntity.this.burningStorage.getMaxBurning();
                }
            }
            throw new IndexOutOfBoundsException(index);
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    HeaterBlockEntity.this.burningStorage.setCurrentBurning(value);
                    break;
                }
                case 1: {
                    HeaterBlockEntity.this.burningStorage.setMaxBurning(value);
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(index);
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private final class_1277 container = new class_1277(1){

        public boolean method_5437(int slot, class_1799 stack) {
            if (slot == 0) {
                return HeaterBlockEntity.this.method_10997().method_61269().method_61752(stack) || stack.method_31574(class_1802.field_8550) && !((class_1799)this.field_5828.get(0)).method_31574(class_1802.field_8550);
            }
            return true;
        }
    };
    private final SimpleBurningStorage burningStorage = new SimpleBurningStorage();
    private final EnumMap<class_2350, InventoryStorage> wrappers = new EnumMap(class_2350.class);
    private final Set<class_2338> cache = new HashSet<class_2338>();
    private final AtomicBoolean dirty = new AtomicBoolean(true);
    private class_1273 lock = class_1273.field_5817;
    @Nullable
    private class_2561 name = null;

    public HeaterBlockEntity(class_2338 pos, class_2680 state) {
        super(HeaterBlockEntityTypes.HEATER, pos, state);
        this.burningStorage.addListener((BurningStorageListener)this);
        this.container.method_5489((class_1265)this);
    }

    public boolean isBurning() {
        return this.burningStorage.getCurrentBurning() > 0;
    }

    public void makeDirty() {
        this.dirty.set(true);
    }

    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        this.lock = class_1273.method_5473((class_11368)input);
        this.name = input.method_71426(CUSTOM_NAME_TAG, class_8824.field_46597).orElse(null);
        this.container.method_5447(0, input.method_71426(ITEM_TAG, class_1799.field_24671).orElse(class_1799.field_8037));
        input.method_71426(BURNING_TAG, SimpleBurningStorage.SNAPSHOT_CODEC).ifPresent(arg_0 -> ((SimpleBurningStorage)this.burningStorage).readSnapshot(arg_0));
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        this.lock.method_5474(output);
        output.method_71477(CUSTOM_NAME_TAG, class_8824.field_46597, (Object)this.name);
        class_1799 fuel = this.container.method_5438(0);
        if (!fuel.method_7960()) {
            output.method_71468(ITEM_TAG, class_1799.field_24671, (Object)fuel);
        }
        output.method_71468(BURNING_TAG, SimpleBurningStorage.SNAPSHOT_CODEC, (Object)this.burningStorage.createSnapshot());
    }

    protected void method_57568(class_9473 getter) {
        super.method_57568(getter);
        this.name = (class_2561)getter.method_58694(class_9334.field_49631);
        this.lock = (class_1273)getter.method_58695(class_9334.field_49625, (Object)class_1273.field_5817);
        ((class_9288)getter.method_58695(class_9334.field_49622, (Object)class_9288.field_49334)).method_57492(this.container.method_54454());
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840(class_9334.field_49631, (Object)this.name);
        if (!this.lock.equals((Object)class_1273.field_5817)) {
            builder.method_57840(class_9334.field_49625, (Object)this.lock);
        }
        builder.method_57840(class_9334.field_49622, (Object)class_9288.method_57493((List)this.container.method_54454()));
    }

    public void burningStorageChanged(BurningStorage storage) {
        BurningStorageHelper.tryUpdateLitProperty((class_2586)this, (BurningStorage)storage);
        this.method_5431();
    }

    public void method_5453(class_1263 container) {
        this.method_5431();
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        if (class_2624.method_17487((class_1657)player, (class_1273)this.lock, (class_2561)this.method_5476())) {
            return new HeaterMenu(syncId, inventory, (class_1263)this.container, this.burningData);
        }
        return null;
    }

    public class_2561 method_5477() {
        return this.name == null ? class_2561.method_43471((String)CONTAINER_NAME) : this.name;
    }

    public class_2561 method_5797() {
        return this.name;
    }

    public void setCustomName(class_2561 name) {
        this.name = name;
    }

    public int method_5439() {
        return this.container.method_5439();
    }

    public boolean method_5442() {
        return this.container.method_5442();
    }

    public class_1799 method_5438(int i) {
        return this.container.method_5438(i);
    }

    public class_1799 method_5434(int i, int j) {
        return this.container.method_5434(i, j);
    }

    public class_1799 method_5441(int i) {
        return this.container.method_5441(i);
    }

    public void method_5447(int i, class_1799 itemStack) {
        this.container.method_5447(i, itemStack);
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public void method_5448() {
        this.container.method_5448();
    }

    public int[] method_5494(class_2350 direction) {
        return SLOTS;
    }

    public boolean method_5492(int i, class_1799 itemStack, class_2350 direction) {
        return this.container.method_5437(i, itemStack);
    }

    public boolean method_5493(int i, class_1799 itemStack, class_2350 direction) {
        return direction != class_2350.field_11033 || itemStack.method_31574(class_1802.field_8705) || itemStack.method_31574(class_1802.field_8550);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, HeaterBlockEntity heater) {
        FuelValuesBurningContext context = new FuelValuesBurningContext(level.method_61269());
        try (Transaction transaction = Transaction.openOuter();){
            class_2248 class_22482;
            if (heater.isBurning()) {
                if (heater.dirty.compareAndSet(true, false)) {
                    heater.cache.clear();
                    new Explorer(level, pos, level.method_8320(pos), 64).onBurningStorageCallback((s, p) -> heater.cache.add((class_2338)p)).run();
                }
                HeaterBlockEntity.propagateBurnTime(level, heater, (BurningContext)context, transaction);
            }
            if (heater.isBurning() && (class_22482 = state.method_26204()) instanceof HeaterBlock) {
                HeaterBlock block = (HeaterBlock)class_22482;
                heater.burningStorage.extract(WeatherStateExtra.burningReduction(heater.burningStorage.getBurning((BurningContext)context), block.getAge(), (BurningContext)context), (BurningContext)context, (TransactionContext)transaction);
            }
            HeaterBlockEntity.consumeFuel(heater, (BurningContext)context, transaction);
            transaction.commit();
        }
    }

    private static void propagateBurnTime(class_1937 level, HeaterBlockEntity heater, BurningContext context, Transaction transaction) {
        TreeSet<BurningStorage> set = new TreeSet<BurningStorage>((a, b) -> Double.compare(a.getBurning(context).getReverseValue(context), b.getBurning(context).getReverseValue(context)));
        for (class_2338 pos : heater.cache) {
            BurningStorage storage = (BurningStorage)BurningStorage.SIDED.find(level, pos, null);
            if (storage == null || !storage.supportsInsertion()) continue;
            set.add(storage);
        }
        BurningStorage[] storages = (BurningStorage[])set.toArray(BurningStorage[]::new);
        if ((storages = Arrays.copyOf(storages, Math.min(storages.length, heater.burningStorage.getCurrentBurning()))).length > 0) {
            Burning deltaBurning = heater.burningStorage.getBurning(context).withValue(Math.round((float)heater.burningStorage.getCurrentBurning() * 1.0f / (float)storages.length), context);
            for (BurningStorage storage : storages) {
                if (storage == null) continue;
                BurningStorage.transfer((BurningStorage)heater.burningStorage, (BurningStorage)storage, (Burning)deltaBurning, (BurningContext)context, (TransactionContext)transaction);
                if (!heater.isBurning()) break;
            }
        }
    }

    private static void consumeFuel(HeaterBlockEntity heater, BurningContext context, Transaction transaction) {
        class_1792 fuelItem;
        Burning burning;
        class_1799 fuelStack = heater.container.method_5438(0);
        if (!heater.isBurning() && !fuelStack.method_7960() && (burning = Burning.of((class_1792)(fuelItem = fuelStack.method_7909()), (BurningContext)context)) != null) {
            fuelStack.method_7934(1);
            if (fuelStack.method_7960()) {
                class_1799 bucketItem = fuelItem.method_7858();
                heater.container.method_5447(0, bucketItem == null ? class_1799.field_8037 : bucketItem);
            }
            heater.burningStorage.insert(burning.one(), context, (TransactionContext)transaction);
        }
    }

    public static InventoryStorage getInventoryStorage(HeaterBlockEntity entity, class_2350 direction) {
        return entity.wrappers.computeIfAbsent(direction, key -> InventoryStorage.of((class_1263)entity.container, (class_2350)key));
    }

    public static BurningStorage getBurningStorage(HeaterBlockEntity entity, class_2350 direction) {
        return entity.burningStorage;
    }

    public static final void updateConnectedHeaters(class_1937 level, class_2338 pos, class_2680 state) {
        new Explorer(level, pos, state, 64).onHeaterFound((h, p) -> level.method_35230(p, HeaterBlockEntityTypes.HEATER).ifPresent(HeaterBlockEntity::makeDirty)).run();
    }
}

