/*
 * Decompiled with CFR 0.152.
 */
package niv.heater.util;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5955;
import niv.burning.api.BurningStorage;
import niv.heater.api.Connector;
import niv.heater.block.HeaterBlock;
import niv.heater.util.WeatherStateExtra;

public class Explorer
implements Runnable {
    private final class_1937 level;
    private final class_2338 posZero;
    private final class_2680 stateZero;
    private final int hopsZero;
    private final Queue<ConnectorHolder> connectors;
    private final Set<class_2338> visited;
    private BiConsumer<BurningStorage, class_2338> onBurningStorageCallback = null;
    private BiConsumer<HeaterBlock, class_2338> onHeaterCallback = null;

    public Explorer(class_1937 level, class_2338 pos, class_2680 state, int hops) {
        this.level = level;
        this.posZero = pos;
        this.stateZero = state;
        this.hopsZero = hops;
        this.connectors = new LinkedList<ConnectorHolder>();
        this.visited = new HashSet<class_2338>();
    }

    public Explorer onBurningStorageCallback(BiConsumer<BurningStorage, class_2338> callback) {
        this.onBurningStorageCallback = callback;
        return this;
    }

    public Explorer onHeaterFound(BiConsumer<HeaterBlock, class_2338> callback) {
        this.onHeaterCallback = callback;
        return this;
    }

    @Override
    public void run() {
        this.connectors.clear();
        this.visited.clear();
        class_2248 class_22482 = this.stateZero.method_26204();
        if (class_22482 instanceof Connector) {
            Connector connector = (Connector)class_22482;
            this.connectors.add(new ConnectorHolder(connector, this.posZero, this.stateZero, this.hopsZero));
            this.visited.add(this.posZero);
        }
        while (!this.connectors.isEmpty()) {
            ConnectorHolder src = this.connectors.poll();
            Explorer.getConnectedNeighbors(src.connector(), this.level, src.pos(), src.state()).forEach((dir, result) -> this.visit(src, (class_2350)dir, (Result)result));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void visit(ConnectorHolder src, class_2350 dir, Result result) {
        HeaterBlock heaterBlock2;
        class_2338 pos = src.pos().method_10093(dir);
        int hops = src.hops();
        Connector connector = src.connector();
        if (connector instanceof class_5955) {
            class_5955 copper = (class_5955)connector;
            hops = Math.max(0, hops - WeatherStateExtra.heatReduction((class_5955.class_5811)copper.method_33622()));
        } else {
            hops = Math.max(0, hops - 1);
        }
        if (this.visited.contains(pos)) return;
        if (hops <= 0) return;
        if (result instanceof ConnectorResult) {
            Connector connector3;
            ConnectorResult connectorResult = (ConnectorResult)result;
            try {
                Connector connector2;
                connector3 = connector2 = connectorResult.connector();
                this.visited.add(pos);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            this.connectors.add(new ConnectorHolder(connector3, pos, this.level.method_8320(pos), hops));
            return;
        }
        if (result instanceof BurningStorageResult) {
            BurningStorage burningStorage2;
            BurningStorageResult burningStorageResult = (BurningStorageResult)result;
            {
                BurningStorage burningStorage;
                burningStorage2 = burningStorage = burningStorageResult.burning();
                if (this.onBurningStorageCallback == null) return;
                this.visited.add(pos);
            }
            this.onBurningStorageCallback.accept(burningStorage2, pos);
            return;
        }
        if (!(result instanceof HeaterResult)) return;
        HeaterResult heaterResult = (HeaterResult)result;
        {
            HeaterBlock heaterBlock;
            heaterBlock2 = heaterBlock = heaterResult.heater();
            if (this.onHeaterCallback == null) return;
            this.visited.add(pos);
        }
        this.onHeaterCallback.accept(heaterBlock2, pos);
    }

    private static final Map<class_2350, Result> getConnectedNeighbors(Connector connector, class_1937 level, class_2338 pos, class_2680 state) {
        EnumMap<class_2350, Result> results = new EnumMap<class_2350, Result>(class_2350.class);
        for (class_2350 direction : connector.getConnected(state)) {
            class_2338 relative = pos.method_10093(direction);
            if (connector.canPropagate(level, pos, level.method_8320(pos), direction)) {
                Optional.empty().or(() -> Explorer.asBurningStorage(level, relative, direction)).or(() -> Explorer.asConnector((class_1922)level, relative)).ifPresent(result -> results.put(direction, (Result)result));
                continue;
            }
            class_2248 class_22482 = level.method_8320(relative).method_26204();
            if (!(class_22482 instanceof HeaterBlock)) continue;
            HeaterBlock heater = (HeaterBlock)class_22482;
            results.put(direction, new HeaterResult(heater));
        }
        return results;
    }

    private static Optional<BurningStorageResult> asBurningStorage(class_1937 level, class_2338 pos, class_2350 direction) {
        return Optional.ofNullable((BurningStorage)BurningStorage.SIDED.find(level, pos, (Object)direction.method_10153())).map(BurningStorageResult::new);
    }

    private static Optional<ConnectorResult> asConnector(class_1922 getter, class_2338 pos) {
        class_2248 block = getter.method_8320(pos).method_26204();
        if (block instanceof Connector) {
            Connector connector = (Connector)block;
            return Optional.of(new ConnectorResult(connector));
        }
        return Optional.empty();
    }

    private record ConnectorHolder(Connector connector, class_2338 pos, class_2680 state, int hops) {
    }

    private record ConnectorResult(Connector connector) implements Result
    {
    }

    private record BurningStorageResult(BurningStorage burning) implements Result
    {
    }

    private record HeaterResult(HeaterBlock heater) implements Result
    {
    }

    private static interface Result {
    }
}

