/*
 * Decompiled with CFR 0.152.
 */
package niv.heater.util;

import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import net.minecraft.class_5955;
import niv.burning.api.Burning;
import niv.burning.api.BurningContext;
import org.apache.commons.lang3.StringUtils;

public class WeatherStateExtra {
    private static final String[] PATH = WeatherStateExtra.generatePath();
    private static final String[] NAME = WeatherStateExtra.generateName();
    private static final ImmutableBiMap<class_5955.class_5811, class_5955.class_5811> BI_MAP = ImmutableBiMap.builder().put((Object)class_5955.class_5811.field_28704, (Object)class_5955.class_5811.field_28705).put((Object)class_5955.class_5811.field_28705, (Object)class_5955.class_5811.field_28706).put((Object)class_5955.class_5811.field_28706, (Object)class_5955.class_5811.field_28707).build();

    private WeatherStateExtra() {
    }

    private static final String[] generatePath() {
        String[] result = new String[4];
        for (class_5955.class_5811 state : class_5955.class_5811.values()) {
            result[state.ordinal()] = class_5955.class_5811.field_28704.equals((Object)state) ? "" : state.name().toLowerCase() + "_";
        }
        return result;
    }

    public static final String toPath(class_5955.class_5811 state) {
        return PATH[state.ordinal()];
    }

    private static final String[] generateName() {
        String[] result = new String[4];
        for (class_5955.class_5811 state : class_5955.class_5811.values()) {
            result[state.ordinal()] = class_5955.class_5811.field_28704.equals((Object)state) ? "" : StringUtils.capitalize((String)state.name().toLowerCase()) + " ";
        }
        return result;
    }

    public static final String toName(class_5955.class_5811 state) {
        return NAME[state.ordinal()];
    }

    public static final Optional<class_5955.class_5811> getNext(class_5955.class_5811 state) {
        return Optional.ofNullable((class_5955.class_5811)BI_MAP.getOrDefault((Object)state, null));
    }

    public static final int heatReduction(class_5955.class_5811 state) {
        switch (state) {
            case field_28707: {
                return 4;
            }
            case field_28706: {
                return 3;
            }
            case field_28705: {
                return 2;
            }
        }
        return 1;
    }

    public static final Burning burningReduction(Burning burning, class_5955.class_5811 state, BurningContext context) {
        return burning.withValue(WeatherStateExtra.heatReduction(state), context);
    }
}

