/*
 * Decompiled with CFR 0.152.
 */
package net.weever.telegramSRV;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.weever.telegramSRV.api.TelegramBot;
import net.weever.telegramSRV.api.registrar.LegacyCommandRegistrar;
import net.weever.telegramSRV.api.registrar.ModernCommandRegistrar;
import net.weever.telegramSRV.api.registrar.base.ICommandRegistrar;
import net.weever.telegramSRV.events.PlayerEvent;
import net.weever.telegramSRV.util.ConfigUtil;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.generics.BotSession;
import org.telegram.telegrambots.updatesreceivers.DefaultBotSession;

public final class TelegramSRV
extends JavaPlugin {
    public static TelegramBot telegramBot;
    public static Logger logger;
    private static BotSession botSession;
    private static Plugin plugin;
    private ICommandRegistrar commandRegistrar;

    public static FileConfiguration config() {
        return plugin.getConfig();
    }

    public static TelegramSRV plugin() {
        return (TelegramSRV)TelegramSRV.getPlugin(TelegramSRV.class);
    }

    public static boolean startTelegramBot() {
        try {
            telegramBot = new TelegramBot();
            TelegramBotsApi botsApi = new TelegramBotsApi(DefaultBotSession.class);
            botSession = botsApi.registerBot(telegramBot);
            logger.info("Telegram SRV is started: " + telegramBot.getBotUsername());
            TelegramSRV.sendServerStatusMessage("start");
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to start Telegram bot: " + e.getMessage(), e);
            TelegramSRV.disablePlugin();
            TelegramSRV.stopBotSession();
            return false;
        }
    }

    private static void sendServerStatusMessage(String status) {
        ConfigUtil.EventValue eventValue = ConfigUtil.getEventConfigValue(ConfigUtil.Events.SERVER);
        if (eventValue.enabled() && !eventValue.isNullChatId()) {
            String threadId = eventValue.isNullThreadId() ? null : eventValue.threadId();
            telegramBot.sendMessage(ConfigUtil.getLocalizedText(ConfigUtil.Events.SERVER, status), eventValue.chatId(), threadId, null);
        }
    }

    private static void disablePlugin() {
        Bukkit.getPluginManager().disablePlugin(plugin);
    }

    private static void stopBotSession() {
        if (botSession != null) {
            try {
                new Thread(TelegramSRV::stopBotSession).start();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to stop Telegram bot session: " + e.getMessage(), e);
            }
        }
    }

    private void setupCommandRegistrar() {
        try {
            Class.forName("io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents");
            this.commandRegistrar = new ModernCommandRegistrar();
        }
        catch (ClassNotFoundException e) {
            this.commandRegistrar = new LegacyCommandRegistrar();
        }
    }

    public void onEnable() {
        plugin = this;
        logger = this.getLogger();
        this.setupCommandRegistrar();
        try {
            this.saveDefaultConfig();
            ConfigUtil.copyDefaultTranslations();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to load plugin: " + e.getMessage(), e);
            TelegramSRV.disablePlugin();
            return;
        }
        if (TelegramSRV.startTelegramBot()) {
            Bukkit.getPluginManager().registerEvents((Listener)new PlayerEvent(), (Plugin)this);
            if (this.commandRegistrar != null) {
                this.commandRegistrar.registerCommands(this);
            } else {
                logger.severe("Could not initialize command registrar. Commands will not work.");
            }
        }
    }

    public void onDisable() {
        try {
            if (botSession != null && botSession.isRunning()) {
                TelegramSRV.sendServerStatusMessage("stop");
                TelegramSRV.stopBotSession();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to send \"Disable\" message: " + e.getMessage(), e);
        }
    }
}

