/*
 * Decompiled with CFR 0.152.
 */
package net.weever.telegramSRV.api.modules;

import net.weever.telegramSRV.TelegramSRV;
import net.weever.telegramSRV.api.modules.commands.TelegramCommandImpl;

public interface ITelegramCommand {
    default public void onCommand(TelegramCommandImpl.ReplyToCommand sender) {
        sender.reply("Command do not have a handler. Please implement it.");
        TelegramCommandImpl.removeCommand(sender.commandName());
    }

    default public boolean perform(String commandName, long userId) {
        return this.isCommandEnabled(commandName) && (!this.isAdminOnly(commandName) || this.isAdmin(userId));
    }

    private boolean isCommandEnabled(String commandName) {
        return TelegramSRV.config().getBoolean("commands." + commandName + ".ENABLED");
    }

    private boolean isAdminOnly(String commandName) {
        return TelegramSRV.config().getBoolean("commands." + commandName + ".FOR_ADMINS");
    }

    private boolean isAdmin(long userId) {
        return TelegramSRV.config().getStringList("ADMINS").contains(String.valueOf(userId));
    }
}

