/*
 * Decompiled with CFR 0.152.
 */
package net.weever.telegramSRV.commands.modern;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import net.weever.telegramSRV.commands.logic.LanguageCommandLogic;
import net.weever.telegramSRV.util.ConfigUtil;
import org.jetbrains.annotations.Nullable;

public class LanguageCommandModern
implements BasicCommand {
    public void execute(CommandSourceStack commandSourceStack, String[] args) {
        LanguageCommandLogic.execute(commandSourceStack.getSender(), args);
    }

    public Collection<String> suggest(CommandSourceStack commandSourceStack, String[] args) {
        if (args.length > 1) {
            return Collections.emptyList();
        }
        return ConfigUtil.getLoadedLanguages().stream().filter(lang -> lang.toLowerCase().startsWith(args.length > 0 ? args[0].toLowerCase() : "")).collect(Collectors.toList());
    }

    @Nullable
    public String permission() {
        return "telegramSRV.admin";
    }
}

