/*
 * Decompiled with CFR 0.152.
 */
package net.weever.telegramSRV.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.weever.telegramSRV.TelegramSRV;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigUtil {
    private static final Set<String> loadedLanguages = Set.of("en", "ru", "ua");
    private static final String langDirPath = "/lang";
    private static final String configFileName = "config.yml";
    private static final String oldConfigFileName = "config.old.yml";
    private static final String langFileExtension = ".yml";
    private static final File dataFolder = TelegramSRV.plugin().getDataFolder();
    private static final String langFile = String.valueOf(dataFolder) + "/lang";
    private static final String configFile = String.valueOf(dataFolder) + "/config.yml";
    private static final String oldConfigFile = String.valueOf(dataFolder) + "/config.old.yml";

    public static void copyDefaultTranslations() {
        File langFolder = new File(langFile);
        if (!langFolder.exists()) {
            langFolder.mkdirs();
            TelegramSRV.logger.info("Created language directory: " + langFolder.getAbsolutePath());
        }
        for (String lang : loadedLanguages) {
            ConfigUtil.copyTranslationFile(lang, langFolder);
        }
        ConfigUtil.copyDefaultConfigFile(langFolder);
    }

    private static void copyTranslationFile(String lang, File langFolder) {
        String resourcePath = "lang/" + lang + langFileExtension;
        InputStream inputStream = TelegramSRV.plugin().getResource(resourcePath);
        if (inputStream != null) {
            File translationFile = new File(langFolder, lang + langFileExtension);
            try (FileOutputStream outputStream = new FileOutputStream(translationFile);){
                inputStream.transferTo(outputStream);
                TelegramSRV.logger.info("Copied translation file: " + translationFile.getName());
            }
            catch (IOException e) {
                TelegramSRV.logger.severe("Error copying translation file for language '" + lang + "': " + e.getMessage());
            }
        } else {
            TelegramSRV.logger.warning("Translation file for language '" + lang + "' not found in resources.");
        }
    }

    private static void copyDefaultConfigFile(File langFolder) {
        File destFile = new File(configFile);
        if (!destFile.exists() || TelegramSRV.config().getKeys(false).isEmpty()) {
            try {
                Files.copy(new File(langFolder, "en.yml").toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                TelegramSRV.logger.info("Copied default config file: " + destFile.getName());
            }
            catch (IOException e) {
                TelegramSRV.logger.severe("Error copying en.yml to config.yml: " + e.getMessage());
                Bukkit.getPluginManager().disablePlugin((Plugin)TelegramSRV.plugin());
            }
        }
    }

    public static void changeLanguage(String language) {
        File sourceFile = new File(langFile + "/" + language + langFileExtension);
        File destFile = new File(configFile);
        File backupFile = new File(oldConfigFile);
        if (sourceFile.exists() && destFile.exists()) {
            try {
                Files.copy(destFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                TelegramSRV.logger.info("Backup created: " + backupFile.getName());
                ConfigUtil.updateConfigFileWithLanguage(language, sourceFile, destFile);
                TelegramSRV.plugin().reloadConfig();
                TelegramSRV.logger.info("Language changed to: " + language.toUpperCase());
            }
            catch (IOException e) {
                TelegramSRV.logger.severe("Problem with changing language: " + e.getMessage());
            }
        } else {
            TelegramSRV.logger.warning(String.format("Language file not found: %s%s", language, langFileExtension));
            TelegramSRV.logger.info("Attempting to recover by copying default translations...");
            ConfigUtil.copyDefaultTranslations();
            if (sourceFile.exists()) {
                TelegramSRV.logger.info("Retry successful, changing language...");
                ConfigUtil.changeLanguage(language);
            } else {
                TelegramSRV.logger.severe("Failed to change language after retry.");
            }
        }
    }

    private static void updateConfigFileWithLanguage(String language, File langFile, File destFile) throws IOException {
        Map<String, Object> settingsMap = ConfigUtil.getSettingsMap();
        YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)langFile);
        for (Map.Entry<String, Object> entry : settingsMap.entrySet()) {
            newConfig.set(entry.getKey(), entry.getValue());
        }
        newConfig.save(destFile);
    }

    private static Map<String, Object> getSettingsMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] keys = new String[]{"BOT_TOKEN", "BOT_NAME", "ADMINS", "forwarding.fromTelegramToMinecraft.enabled", "forwarding.fromTelegramToMinecraft.requirePrefix", "forwarding.fromTelegramToMinecraft.prefix", "forwarding.fromMinecraftToTelegram.enabled", "forwarding.fromMinecraftToTelegram.requirePrefix", "forwarding.fromMinecraftToTelegram.prefix", "SERVER_STATUS", "SERVER_STATUS_CHAT_ID", "SERVER_STATUS_THREAD_ID", "PLAYER_STATUS", "PLAYER_STATUS_CHAT_ID", "PLAYER_STATUS_THREAD_ID"};
        try {
            for (String key : keys) {
                Object value = TelegramSRV.config().get(key);
                if (value == null) continue;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            TelegramSRV.logger.severe("Error getting settings map: " + e.getMessage());
            return Collections.emptyMap();
        }
        return map;
    }

    public static void changeThreadId(Events event, String threadId) {
        TelegramSRV.config().set(event.name().toUpperCase() + "_STATUS_THREAD_ID", (Object)Integer.valueOf(threadId));
        TelegramSRV.plugin().saveConfig();
    }

    public static String getCommandDescription(String commandName) {
        return TelegramSRV.config().getString("commands." + commandName.toLowerCase() + ".DESCRIPTION");
    }

    public static EventValue getEventConfigValue(Events event) {
        boolean status = TelegramSRV.config().getBoolean(event.name() + "_STATUS");
        String chatId = TelegramSRV.config().getString(event.name() + "_STATUS_CHAT_ID");
        String threadId = TelegramSRV.config().getString(event.name() + "_STATUS_THREAD_ID");
        return new EventValue(status, chatId, threadId);
    }

    private static String getForwardingPath(boolean fromTelegramToMinecraft) {
        return fromTelegramToMinecraft ? "forwarding.fromTelegramToMinecraft" : "forwarding.fromMinecraftToTelegram";
    }

    public static boolean isForwardingEnabled(boolean fromTelegramToMinecraft) {
        return TelegramSRV.config().getBoolean(ConfigUtil.getForwardingPath(fromTelegramToMinecraft) + ".enabled", true);
    }

    public static boolean isPrefixRequired(boolean fromTelegramToMinecraft) {
        return TelegramSRV.config().getBoolean(ConfigUtil.getForwardingPath(fromTelegramToMinecraft) + ".requirePrefix", false);
    }

    public static String getPrefix(boolean fromTelegramToMinecraft) {
        return TelegramSRV.config().getString(ConfigUtil.getForwardingPath(fromTelegramToMinecraft) + ".prefix", fromTelegramToMinecraft ? "!" : "/tg");
    }

    public static String getLocalizedText(String name, String key) {
        String answer = TelegramSRV.config().getString("text." + name + "." + key);
        return answer == null ? "unknown" : answer;
    }

    public static String getLocalizedText(Events event, String key) {
        return ConfigUtil.getLocalizedText(event.name().toLowerCase(), key);
    }

    @Generated
    public static Set<String> getLoadedLanguages() {
        return loadedLanguages;
    }

    public static enum Events {
        PLAYER,
        SERVER,
        CONSOLE;

    }

    public record EventValue(boolean enabled, String chatId, String threadId) {
        public boolean isNullThreadId() {
            return this.threadId == null || this.threadId.isEmpty() || this.threadId.equals("YOUR_THREAD_ID");
        }

        public boolean isNullChatId() {
            return this.chatId == null || this.chatId.isEmpty() || this.chatId.equals("YOUR_CHAT_ID");
        }
    }
}

