/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.stickers.Sticker;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class GetCustomEmojiStickers
extends BotApiMethod<ArrayList<Sticker>> {
    private static final String PATH = "getCustomEmojiStickers";
    private static final String CUSTOMEMOJIID_FIELD = "custom_emoji_ids";
    @JsonProperty(value="custom_emoji_ids")
    private List<String> customEmojiIds;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.customEmojiIds == null || this.customEmojiIds.isEmpty() || this.customEmojiIds.size() > 200) {
            throw new TelegramApiValidationException("CustomEmojiIds must be between 1 and 200", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public ArrayList<Sticker> deserializeResponse(String answer) throws TelegramApiRequestException {
        return (ArrayList)this.deserializeResponseArray(answer, Sticker.class);
    }

    public static GetCustomEmojiStickersBuilder builder() {
        return new GetCustomEmojiStickersBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetCustomEmojiStickers)) {
            return false;
        }
        GetCustomEmojiStickers other = (GetCustomEmojiStickers)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$customEmojiIds = this.getCustomEmojiIds();
        List<String> other$customEmojiIds = other.getCustomEmojiIds();
        return !(this$customEmojiIds == null ? other$customEmojiIds != null : !((Object)this$customEmojiIds).equals(other$customEmojiIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetCustomEmojiStickers;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $customEmojiIds = this.getCustomEmojiIds();
        result = result * 59 + ($customEmojiIds == null ? 43 : ((Object)$customEmojiIds).hashCode());
        return result;
    }

    public List<String> getCustomEmojiIds() {
        return this.customEmojiIds;
    }

    @JsonProperty(value="custom_emoji_ids")
    public void setCustomEmojiIds(List<String> customEmojiIds) {
        this.customEmojiIds = customEmojiIds;
    }

    public String toString() {
        return "GetCustomEmojiStickers(customEmojiIds=" + this.getCustomEmojiIds() + ")";
    }

    public GetCustomEmojiStickers() {
    }

    public GetCustomEmojiStickers(List<String> customEmojiIds) {
        this.customEmojiIds = customEmojiIds;
    }

    public static class GetCustomEmojiStickersBuilder {
        private ArrayList<String> customEmojiIds;

        GetCustomEmojiStickersBuilder() {
        }

        public GetCustomEmojiStickersBuilder customEmojiId(String customEmojiId) {
            if (this.customEmojiIds == null) {
                this.customEmojiIds = new ArrayList();
            }
            this.customEmojiIds.add(customEmojiId);
            return this;
        }

        @JsonProperty(value="custom_emoji_ids")
        public GetCustomEmojiStickersBuilder customEmojiIds(Collection<? extends String> customEmojiIds) {
            if (customEmojiIds == null) {
                throw new NullPointerException("customEmojiIds cannot be null");
            }
            if (this.customEmojiIds == null) {
                this.customEmojiIds = new ArrayList();
            }
            this.customEmojiIds.addAll(customEmojiIds);
            return this;
        }

        public GetCustomEmojiStickersBuilder clearCustomEmojiIds() {
            if (this.customEmojiIds != null) {
                this.customEmojiIds.clear();
            }
            return this;
        }

        public GetCustomEmojiStickers build() {
            List<String> customEmojiIds;
            switch (this.customEmojiIds == null ? 0 : this.customEmojiIds.size()) {
                case 0: {
                    customEmojiIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    customEmojiIds = Collections.singletonList(this.customEmojiIds.get(0));
                    break;
                }
                default: {
                    customEmojiIds = Collections.unmodifiableList(new ArrayList<String>(this.customEmojiIds));
                }
            }
            return new GetCustomEmojiStickers(customEmojiIds);
        }

        public String toString() {
            return "GetCustomEmojiStickers.GetCustomEmojiStickersBuilder(customEmojiIds=" + this.customEmojiIds + ")";
        }
    }
}

