/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetStickerKeywords
extends BotApiMethodBoolean {
    public static final String PATH = "setStickerKeywords";
    public static final String STICKER_FIELD = "sticker";
    public static final String KEYWORDS_FIELD = "keywords";
    @JsonProperty(value="sticker")
    @NonNull
    private String sticker;
    @JsonProperty(value="keywords")
    private List<String> keywords;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.sticker.isEmpty()) {
            throw new TelegramApiValidationException("sticker can't be null", this);
        }
        if (this.keywords != null && this.keywords.size() > 20) {
            throw new TelegramApiValidationException("Keywords list must have between 0 and 20 items", this);
        }
    }

    public static SetStickerKeywordsBuilder builder() {
        return new SetStickerKeywordsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetStickerKeywords)) {
            return false;
        }
        SetStickerKeywords other = (SetStickerKeywords)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sticker = this.getSticker();
        String other$sticker = other.getSticker();
        if (this$sticker == null ? other$sticker != null : !this$sticker.equals(other$sticker)) {
            return false;
        }
        List<String> this$keywords = this.getKeywords();
        List<String> other$keywords = other.getKeywords();
        return !(this$keywords == null ? other$keywords != null : !((Object)this$keywords).equals(other$keywords));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetStickerKeywords;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sticker = this.getSticker();
        result = result * 59 + ($sticker == null ? 43 : $sticker.hashCode());
        List<String> $keywords = this.getKeywords();
        result = result * 59 + ($keywords == null ? 43 : ((Object)$keywords).hashCode());
        return result;
    }

    @NonNull
    public String getSticker() {
        return this.sticker;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="sticker")
    public void setSticker(@NonNull String sticker) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
    }

    @JsonProperty(value="keywords")
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public String toString() {
        return "SetStickerKeywords(sticker=" + this.getSticker() + ", keywords=" + this.getKeywords() + ")";
    }

    public SetStickerKeywords() {
    }

    public SetStickerKeywords(@NonNull String sticker) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
    }

    public SetStickerKeywords(@NonNull String sticker, List<String> keywords) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
        this.keywords = keywords;
    }

    public static class SetStickerKeywordsBuilder {
        private String sticker;
        private ArrayList<String> keywords;

        SetStickerKeywordsBuilder() {
        }

        @JsonProperty(value="sticker")
        public SetStickerKeywordsBuilder sticker(@NonNull String sticker) {
            if (sticker == null) {
                throw new NullPointerException("sticker is marked non-null but is null");
            }
            this.sticker = sticker;
            return this;
        }

        public SetStickerKeywordsBuilder keyword(String keyword) {
            if (this.keywords == null) {
                this.keywords = new ArrayList();
            }
            this.keywords.add(keyword);
            return this;
        }

        @JsonProperty(value="keywords")
        public SetStickerKeywordsBuilder keywords(Collection<? extends String> keywords) {
            if (keywords == null) {
                throw new NullPointerException("keywords cannot be null");
            }
            if (this.keywords == null) {
                this.keywords = new ArrayList();
            }
            this.keywords.addAll(keywords);
            return this;
        }

        public SetStickerKeywordsBuilder clearKeywords() {
            if (this.keywords != null) {
                this.keywords.clear();
            }
            return this;
        }

        public SetStickerKeywords build() {
            List<String> keywords;
            switch (this.keywords == null ? 0 : this.keywords.size()) {
                case 0: {
                    keywords = Collections.emptyList();
                    break;
                }
                case 1: {
                    keywords = Collections.singletonList(this.keywords.get(0));
                    break;
                }
                default: {
                    keywords = Collections.unmodifiableList(new ArrayList<String>(this.keywords));
                }
            }
            return new SetStickerKeywords(this.sticker, keywords);
        }

        public String toString() {
            return "SetStickerKeywords.SetStickerKeywordsBuilder(sticker=" + this.sticker + ", keywords=" + this.keywords + ")";
        }
    }
}

