/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.boost.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.objects.boost.ChatBoostSource;
import org.telegram.telegrambots.meta.api.objects.boost.ChatBoostSourcePremium;

public class ChatBoostSourceDeserializer
extends StdDeserializer<ChatBoostSource> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ChatBoostSourceDeserializer() {
        this((Class<?>)null);
    }

    private ChatBoostSourceDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public ChatBoostSource deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (node.has("source")) {
            String source = node.get("source").asText();
            if ("premium".equals(source)) {
                return this.objectMapper.readValue(node.toString(), new TypeReference<ChatBoostSourcePremium>(){});
            }
            if ("gift_code".equals(source)) {
                return this.objectMapper.readValue(node.toString(), new TypeReference<ChatBoostSourcePremium>(){});
            }
            if ("giveaway".equals(source)) {
                return this.objectMapper.readValue(node.toString(), new TypeReference<ChatBoostSourcePremium>(){});
            }
        }
        return null;
    }
}

