/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.media;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InputMediaDocument
extends InputMedia {
    private static final String TYPE = "document";
    public static final String THUMBNAIL_FIELD = "thumbnail";
    public static final String DISABLECONTENTTYPEDETECTION_FIELD = "disable_content_type_detection";
    private InputFile thumbnail;
    @JsonProperty(value="disable_content_type_detection")
    private Boolean disableContentTypeDetection;

    public InputMediaDocument() {
    }

    public InputMediaDocument(@NonNull String media) {
        super(media);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
    }

    public InputMediaDocument(@NonNull String media, String caption, String parseMode, List<MessageEntity> entities, boolean isNewMedia, String mediaName, File newMediaFile, InputStream newMediaStream, InputFile thumbnail, Boolean disableContentTypeDetection) {
        super(media, caption, parseMode, entities, isNewMedia, mediaName, newMediaFile, newMediaStream);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.thumbnail = thumbnail;
        this.disableContentTypeDetection = disableContentTypeDetection;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        super.validate();
    }

    @JsonIgnore
    @Deprecated
    public InputFile getThumb() {
        return this.thumbnail;
    }

    @JsonIgnore
    @Deprecated
    public void setThumb(InputFile thumb) {
        this.thumbnail = thumb;
    }

    public static InputMediaDocumentBuilder builder() {
        return new InputMediaDocumentBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputMediaDocument)) {
            return false;
        }
        InputMediaDocument other = (InputMediaDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$disableContentTypeDetection = this.getDisableContentTypeDetection();
        Boolean other$disableContentTypeDetection = other.getDisableContentTypeDetection();
        if (this$disableContentTypeDetection == null ? other$disableContentTypeDetection != null : !((Object)this$disableContentTypeDetection).equals(other$disableContentTypeDetection)) {
            return false;
        }
        InputFile this$thumbnail = this.getThumbnail();
        InputFile other$thumbnail = other.getThumbnail();
        return !(this$thumbnail == null ? other$thumbnail != null : !((Object)this$thumbnail).equals(other$thumbnail));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InputMediaDocument;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $disableContentTypeDetection = this.getDisableContentTypeDetection();
        result = result * 59 + ($disableContentTypeDetection == null ? 43 : ((Object)$disableContentTypeDetection).hashCode());
        InputFile $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : ((Object)$thumbnail).hashCode());
        return result;
    }

    public InputFile getThumbnail() {
        return this.thumbnail;
    }

    public Boolean getDisableContentTypeDetection() {
        return this.disableContentTypeDetection;
    }

    public void setThumbnail(InputFile thumbnail) {
        this.thumbnail = thumbnail;
    }

    @JsonProperty(value="disable_content_type_detection")
    public void setDisableContentTypeDetection(Boolean disableContentTypeDetection) {
        this.disableContentTypeDetection = disableContentTypeDetection;
    }

    @Override
    public String toString() {
        return "InputMediaDocument(thumbnail=" + this.getThumbnail() + ", disableContentTypeDetection=" + this.getDisableContentTypeDetection() + ")";
    }

    public static class InputMediaDocumentBuilder {
        private String media;
        private String caption;
        private String parseMode;
        private List<MessageEntity> entities;
        private boolean isNewMedia;
        private String mediaName;
        private File newMediaFile;
        private InputStream newMediaStream;
        private InputFile thumbnail;
        private Boolean disableContentTypeDetection;

        @Deprecated
        public InputMediaDocumentBuilder thumb(InputFile thumb) {
            this.thumbnail = thumb;
            return this;
        }

        InputMediaDocumentBuilder() {
        }

        public InputMediaDocumentBuilder media(@NonNull String media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return this;
        }

        public InputMediaDocumentBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InputMediaDocumentBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public InputMediaDocumentBuilder entities(List<MessageEntity> entities) {
            this.entities = entities;
            return this;
        }

        public InputMediaDocumentBuilder isNewMedia(boolean isNewMedia) {
            this.isNewMedia = isNewMedia;
            return this;
        }

        public InputMediaDocumentBuilder mediaName(String mediaName) {
            this.mediaName = mediaName;
            return this;
        }

        public InputMediaDocumentBuilder newMediaFile(File newMediaFile) {
            this.newMediaFile = newMediaFile;
            return this;
        }

        public InputMediaDocumentBuilder newMediaStream(InputStream newMediaStream) {
            this.newMediaStream = newMediaStream;
            return this;
        }

        public InputMediaDocumentBuilder thumbnail(InputFile thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public InputMediaDocumentBuilder disableContentTypeDetection(Boolean disableContentTypeDetection) {
            this.disableContentTypeDetection = disableContentTypeDetection;
            return this;
        }

        public InputMediaDocument build() {
            return new InputMediaDocument(this.media, this.caption, this.parseMode, this.entities, this.isNewMedia, this.mediaName, this.newMediaFile, this.newMediaStream, this.thumbnail, this.disableContentTypeDetection);
        }

        public String toString() {
            return "InputMediaDocument.InputMediaDocumentBuilder(media=" + this.media + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", entities=" + this.entities + ", isNewMedia=" + this.isNewMedia + ", mediaName=" + this.mediaName + ", newMediaFile=" + this.newMediaFile + ", newMediaStream=" + this.newMediaStream + ", thumbnail=" + this.thumbnail + ", disableContentTypeDetection=" + this.disableContentTypeDetection + ")";
        }
    }
}

