/*
 * Decompiled with CFR 0.152.
 */
package ho.artisan.tgears.client.visual;

import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import ho.artisan.tgears.common.block.AbstractTinkerDrillBlock;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TinkerDrillActorVisual
extends ActorVisual {
    TransformedInstance drillHead;
    private final Direction facing;
    private double rotation;
    private double previousRotation;

    public TinkerDrillActorVisual(VisualizationContext visualizationContext, VirtualRenderWorld contraption, MovementContext context, PartialModel model) {
        super(visualizationContext, (BlockAndTintGetter)contraption, context);
        BlockState state = context.state;
        this.facing = (Direction)state.m_61143_((Property)AbstractTinkerDrillBlock.FACING);
        this.drillHead = (TransformedInstance)this.instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)model)).createInstance();
    }

    public void tick() {
        this.previousRotation = this.rotation;
        if (this.context.disabled || VecHelper.isVecPointingTowards((Vec3)this.context.relativeMotion, (Direction)this.facing.m_122424_())) {
            return;
        }
        float deg = this.context.getAnimationSpeed();
        this.rotation += (double)(deg / 20.0f);
        this.rotation %= 360.0;
    }

    public void beginFrame() {
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.drillHead.setIdentityTransform().translate((Vec3i)this.context.localPos)).center()).rotateToFace(this.facing.m_122424_())).rotateZDegrees((float)this.getRotation())).uncenter()).setChanged();
    }

    protected double getRotation() {
        return AngleHelper.angleLerp((double)AnimationTickHolder.getPartialTicks(), (double)this.previousRotation, (double)this.rotation);
    }

    protected void _delete() {
        this.drillHead.delete();
    }
}

