/*
 * Decompiled with CFR 0.152.
 */
package ho.artisan.tgears.common.block.entity.behaviour;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import ho.artisan.tgears.common.block.TinkerDismantlerBlock;
import ho.artisan.tgears.common.block.entity.TinkerDismantlerBlockEntity;
import ho.artisan.tgears.common.block.entity.module.TinkerItemStackModule;
import ho.artisan.tgears.common.recipe.DismantlingRecipe;
import ho.artisan.tgears.index.TGRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolPartsHook;
import slimeknights.tconstruct.library.tools.part.IToolPart;

public class TinkerDismantlingBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<TinkerDismantlingBehaviour> TYPE = new BehaviourType();
    TinkerItemStackModule module = new TinkerItemStackModule(1, 9, () -> this.locked);
    LazyOptional<ItemStackHandler> lazyItemHandler = LazyOptional.of(() -> this.module);
    int timer = 0;
    boolean locked = false;

    public TinkerDismantlingBehaviour(TinkerDismantlerBlockEntity be) {
        super((SmartBlockEntity)be);
        this.module.addListener(stackModule -> {
            boolean flag = !stackModule.getInput(0).m_41619_();
            this.setLocked(flag);
            this.getWorld().m_7731_(this.getPos(), (BlockState)this.blockEntity.m_58900_().m_61124_((Property)TinkerDismantlerBlock.CLAMPED, (Comparable)Boolean.valueOf(flag)), 3);
        });
    }

    public Optional<DismantlingRecipe> getRecipe() {
        return TGRecipeTypes.DISMANTLING.find(this.module, this.getWorld());
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128365_("Inventory", (Tag)this.module.serializeNBT());
        nbt.m_128405_("Timer", this.timer);
        nbt.m_128379_("Locked", this.locked);
        super.write(nbt, clientPacket);
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        this.module.deserializeNBT(nbt.m_128469_("Inventory"));
        this.timer = nbt.m_128451_("Timer");
        this.locked = nbt.m_128471_("Locked");
        super.read(nbt, clientPacket);
    }

    public void setTinkerable(ItemStack stack) {
        this.module.setStackInSlot(0, stack);
    }

    public boolean isEmpty() {
        boolean empty = this.module.getStackInSlot(0).m_41619_();
        return empty;
    }

    public NonNullList<ItemStack> getItemStacks() {
        NonNullList list = NonNullList.m_122779_();
        for (int i = 0; i < this.module.getSlots(); ++i) {
            if (this.module.getStackInSlot(i).m_41619_()) continue;
            list.add((Object)this.module.getStackInSlot(i));
        }
        return list;
    }

    public void tick() {
        super.tick();
        Optional<DismantlingRecipe> recipe = this.getRecipe();
        if (recipe.isPresent() || this.module.isTinkerable()) {
            ++this.timer;
            int threshold = recipe.map(DismantlingRecipe::getTime).orElse(200);
            if (this.timer >= threshold) {
                this.timer = 0;
                recipe.ifPresentOrElse(this::processRecipe, this::process);
            }
        }
    }

    public void addPart(ItemStack stack) {
        for (int i = 0; i < this.module.getOutputSlots(); ++i) {
            if (!this.module.getOutput(i).m_41619_()) continue;
            this.module.setOutput(i, stack);
            return;
        }
    }

    public void processRecipe(DismantlingRecipe recipe) {
        List<ItemStack> stacks = recipe.assembleAll(this.module, this.getWorld().m_213780_());
        stacks.forEach(this::addPart);
        this.setTinkerable(ItemStack.f_41583_);
    }

    public void process() {
        ToolDefinition definition = this.module.getTinkerable().getDefinition();
        if (definition == ToolDefinition.EMPTY) {
            return;
        }
        List parts = ToolPartsHook.parts((ToolDefinition)definition);
        for (int i = 0; i < parts.size(); ++i) {
            IToolPart part = (IToolPart)parts.get(i);
            MaterialVariant variant = this.module.getTinkerable().getMaterial(i);
            if (i == 0) {
                this.addPart(part.withMaterial(variant.getVariant()));
                continue;
            }
            if (!(this.getWorld().m_213780_().m_188501_() < 0.5f)) continue;
            this.addPart(part.withMaterial(variant.getVariant()));
        }
        this.setTinkerable(ItemStack.f_41583_);
    }

    public <T> LazyOptional<T> getItemCapability(Capability<T> cap, Direction side) {
        return this.lazyItemHandler.cast();
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public TinkerItemStackModule getModule() {
        return this.module;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }
}

