/*
 * Decompiled with CFR 0.152.
 */
package ho.artisan.tgears.common.block.entity.module;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import ho.artisan.tgears.util.BlazeBurnerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.SolidFuelModule;

public class BurnerModule
extends SolidFuelModule {
    private final BlockPos fuelPos;

    public BurnerModule(MantleBlockEntity parent, BlockPos fuelPos) {
        super(parent, fuelPos);
        this.fuelPos = fuelPos;
    }

    public boolean isBurner() {
        BlockState state = this.parent.m_58904_().m_8055_(this.fuelPos);
        if (state.m_60713_((Block)AllBlocks.BLAZE_BURNER.get())) {
            return ((BlazeBurnerBlock.HeatLevel)state.m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL)).isAtLeast(BlazeBurnerBlock.HeatLevel.SMOULDERING);
        }
        return false;
    }

    public float getBurningFactor() {
        BlockState state = this.parent.m_58904_().m_8055_(this.fuelPos);
        if (state.m_60713_((Block)AllBlocks.BLAZE_BURNER.get())) {
            return BlazeBurnerUtil.getFactor((BlazeBurnerBlock.HeatLevel)state.m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL));
        }
        return 0.0f;
    }

    public int findFuel(boolean consume) {
        if (this.isBurner()) {
            return (int)(800.0f * this.getBurningFactor());
        }
        return super.findFuel(consume);
    }

    public int getTemperature() {
        if (this.isBurner()) {
            return (int)(800.0f * this.getBurningFactor());
        }
        return super.getTemperature();
    }

    public int getRate() {
        if (this.isBurner()) {
            return (int)(this.getBurningFactor() * 10.0f);
        }
        return super.getRate();
    }

    public boolean hasFuel() {
        return this.isBurner() || super.hasFuel();
    }

    public void decreaseFuel(int amount) {
        if (!this.isBurner()) {
            super.decreaseFuel(amount);
        }
    }
}

