/*
 * Decompiled with CFR 0.152.
 */
package ho.artisan.tgears;

import net.minecraftforge.common.ForgeConfigSpec;

public class TinkersGearsConfig {
    public static final ForgeConfigSpec.ConfigValue<Float> EXTINGUISHED_FACTOR;
    public static final ForgeConfigSpec.ConfigValue<Float> KINDLED_FACTOR;
    public static final ForgeConfigSpec.ConfigValue<Float> SEETHING_FACTOR;
    public static final ForgeConfigSpec.ConfigValue<Float> POLISHING_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Float> POLISHING_SHIELD;
    public static final ForgeConfigSpec.ConfigValue<Integer> CRUSHING_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Float> FAN_RANGE;
    public static final ForgeConfigSpec.ConfigValue<Float> DRILL_SPEED;
    public static final ForgeConfigSpec.ConfigValue<Double> SILK_TOUCH_DRILL_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Integer> FORTUNE_DRILL_LEVEL;
    public static final ForgeConfigSpec.ConfigValue<Boolean> IS_GOGGLES_ENABLED;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        ForgeConfigSpec.Builder client = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder common = new ForgeConfigSpec.Builder();
        common.push("The Blaze Burner Factors(temperature = 800 * factor, rate = 10 * factor)");
        EXTINGUISHED_FACTOR = common.comment("Factor when the burner is extinguished").define("extinguished_factor", (Object)Float.valueOf(0.5f));
        KINDLED_FACTOR = common.comment("Factor when the burner is kindled").define("kindled_factor", (Object)Float.valueOf(1.0f));
        SEETHING_FACTOR = common.comment("Factor when the burner is seething").define("seething_factor", (Object)Float.valueOf(2.0f));
        common.pop();
        common.push("The Polishing Percentages");
        POLISHING_DAMAGE = common.comment("The damage to item when polishing").define("polishing_damage", (Object)Float.valueOf(0.1f));
        POLISHING_SHIELD = common.comment("The shield provided when polishing").define("polishing_shield", (Object)Float.valueOf(0.1f));
        common.pop();
        common.push("The Crushing");
        CRUSHING_DAMAGE = common.comment("The damage to tool with crushing modifier").define("crushing_damage", (Object)5);
        common.pop();
        common.push("The Tinker's Machines");
        FAN_RANGE = common.comment("The ratio of the range to the normal fan").define("fan_range", (Object)Float.valueOf(1.5f));
        DRILL_SPEED = common.comment("The ratio of the speed to the normal drill").define("drill_speed", (Object)Float.valueOf(2.0f));
        SILK_TOUCH_DRILL_DAMAGE = common.comment("The damage to entity from the silk touch drill").define("silk_touch_drill_damage", (Object)1.0);
        FORTUNE_DRILL_LEVEL = common.comment("The fortune level of the fortune drill").define("fortune_drill_level", (Object)3);
        common.pop();
        client.push("The Client Settings");
        IS_GOGGLES_ENABLED = client.comment("Enable the goggles when looking at TConstruct blocks").define("is_goggles_enabled", true);
        client.pop();
        CLIENT_SPEC = client.build();
        COMMON_SPEC = common.build();
    }
}

