/*
 * Decompiled with CFR 0.152.
 */
package ho.artisan.tgears.common.block.behaviour;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.simibubi.create.foundation.damageTypes.CreateDamageSources;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import ho.artisan.tgears.client.renderer.TinkerDrillRenderer;
import ho.artisan.tgears.client.visual.TinkerDrillActorVisual;
import ho.artisan.tgears.common.block.AbstractTinkerDrillBlock;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TinkerDrillMovementBehaviour
extends BlockBreakingMovementBehaviour {
    private final PartialModel model;

    public TinkerDrillMovementBehaviour(PartialModel model) {
        this.model = model;
    }

    public ItemStack createTool() {
        return new ItemStack((ItemLike)Items.f_42390_);
    }

    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)((Direction)context.state.m_61143_((Property)AbstractTinkerDrillBlock.FACING)).m_122424_());
    }

    protected void destroyBlock(MovementContext context, BlockPos breakingPos) {
        Level level = context.world;
        this.breakBlock(context, level, breakingPos, this::createTool);
    }

    private void breakBlock(MovementContext context, Level level, BlockPos pos, Supplier<ItemStack> tool) {
        BlockHelper.destroyBlockAs((Level)level, (BlockPos)pos, null, (ItemStack)tool.get(), (float)1.0f, stack -> {
            ItemStack remainder = (Boolean)AllConfigs.server().kinetics.moveItemsToStorage.get() != false ? ItemHandlerHelper.insertItem((IItemHandler)context.contraption.getStorage().getAllItems(), (ItemStack)stack, (boolean)false) : stack;
            if (remainder.m_41619_()) {
                return;
            }
            Vec3 vec = context.position;
            if (vec == null) {
                return;
            }
            ItemEntity itemEntity = new ItemEntity(context.world, vec.f_82479_, vec.f_82480_, vec.f_82481_, remainder);
            itemEntity.m_20256_(context.motion.m_82520_(0.0, 0.5, 0.0).m_82490_((double)(context.world.f_46441_.m_188501_() * 0.3f)));
            context.world.m_7967_((Entity)itemEntity);
        });
    }

    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)AbstractTinkerDrillBlock.FACING)).m_122436_()).m_82490_((double)0.65f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        if (!VisualizationManager.supportsVisualization((LevelAccessor)context.world)) {
            TinkerDrillRenderer.renderInContraption(context, renderWorld, matrices, buffer, this.model);
        }
    }

    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new TinkerDrillActorVisual(visualizationContext, simulationWorld, movementContext, this.model);
    }

    public boolean disableBlockEntityRendering() {
        return true;
    }

    protected DamageSource getDamageSource(Level level) {
        return CreateDamageSources.drill((Level)level);
    }

    public boolean canBreak(Level world, BlockPos breakingPos, BlockState state) {
        return super.canBreak(world, breakingPos, state) && !state.m_60812_((BlockGetter)world, breakingPos).m_83281_() && !AllTags.AllBlockTags.TRACKS.matches(state);
    }
}

