/*
 * Decompiled with CFR 0.152.
 */
package ho.artisan.tgears.common.modifier;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.crusher.CrushingRecipe;
import ho.artisan.tgears.TinkersGearsConfig;
import ho.artisan.tgears.common.block.module.CrushingItemModule;
import ho.artisan.tgears.index.TGTagKeys;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class CreateCrushingModifier
extends NoLevelsModifier
implements ProcessLootModifierHook {
    private final Cache<Item, Optional<CrushingRecipe>> recipeCache = CacheBuilder.newBuilder().maximumSize(64L).build();
    private final CrushingItemModule inventory = new CrushingItemModule();

    public CreateCrushingModifier() {
        RecipeCacheInvalidator.addReloadListener(client -> {
            if (!client) {
                this.recipeCache.invalidateAll();
            }
        });
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.PROCESS_LOOT);
    }

    private Optional<CrushingRecipe> findRecipe(ItemStack stack, Level world) {
        this.inventory.setStackInSlot(0, stack);
        return world.m_7465_().m_44015_(AllRecipeTypes.CRUSHING.getType(), (Container)new RecipeWrapper((IItemHandlerModifiable)this.inventory), world);
    }

    @Nullable
    private CrushingRecipe findCachedRecipe(ItemStack stack, Level world) {
        if (stack.m_41782_()) {
            return this.findRecipe(stack, world).orElse(null);
        }
        try {
            return ((Optional)this.recipeCache.get((Object)stack.m_41720_(), () -> this.findRecipe(stack, world))).orElse(null);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    private List<ItemStack> crushingItem(ItemStack stack, Level world) {
        if (stack.m_204117_(TGTagKeys.Items.CRUSHING_BLACKLIST)) {
            return List.of(stack);
        }
        CrushingRecipe recipe = this.findCachedRecipe(stack, world);
        if (recipe != null) {
            this.inventory.setStackInSlot(0, stack);
            List list = recipe.rollResults();
            list.removeIf(ItemStack::m_41619_);
            list.forEach(item -> item.m_41764_(item.m_41613_() * stack.m_41613_()));
            return list;
        }
        return List.of(stack);
    }

    public void processLoot(IToolStackView tool, ModifierEntry modifier, List<ItemStack> generatedLoot, LootContext context) {
        ServerLevel world = context.m_78952_();
        if (!generatedLoot.isEmpty()) {
            ToolDamageUtil.damage((IToolStackView)tool, (int)((Integer)TinkersGearsConfig.CRUSHING_DAMAGE.get() * generatedLoot.size()), null, null);
            ArrayList<ItemStack> crushedLoot = new ArrayList<ItemStack>();
            for (ItemStack originalStack : generatedLoot) {
                List<ItemStack> crushed = this.crushingItem(originalStack.m_41777_(), (Level)world);
                crushedLoot.addAll(crushed);
            }
            generatedLoot.clear();
            generatedLoot.addAll(crushedLoot);
        }
    }
}

