/*
 * Decompiled with CFR 0.152.
 */
package ho.artisan.tgears.common.recipe;

import ho.artisan.tgears.index.TGRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import slimeknights.mantle.recipe.ICommonRecipe;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public record DismantlingRecipe(ResourceLocation id, List<PartStack> parts, Ingredient ingredient, int primary, int time) implements ICommonRecipe<ITinkerableContainer>
{
    public boolean matches(ITinkerableContainer container, Level level) {
        return this.ingredient.test(container.getTinkerableStack());
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.parts.get((int)this.primary).stack;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ItemStack assemble(ITinkerableContainer inv, RegistryAccess access) {
        ItemStack result = this.m_8043_(access);
        Item item = result.m_41720_();
        if (item instanceof IMaterialItem) {
            IMaterialItem item2 = (IMaterialItem)item;
            result = this.assemble(item2, inv.getTinkerable().getMaterial(this.primary));
        }
        return result;
    }

    public ItemStack assemble(IMaterialItem item, MaterialVariant material) {
        return item.withMaterial(material.getVariant());
    }

    public List<ItemStack> assembleAll(ITinkerableContainer inv, RandomSource random) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (PartStack part : this.parts) {
            int slot = this.parts.indexOf(part);
            if (slot != this.primary && !(random.m_188501_() < part.chance)) continue;
            Item item = part.stack.m_41720_();
            if (item instanceof IMaterialItem) {
                IMaterialItem item2 = (IMaterialItem)item;
                MaterialVariant variant = inv.getTinkerable().getMaterial(slot);
                if (variant == MaterialVariant.UNKNOWN) continue;
                result.add(this.assemble(item2, variant));
                continue;
            }
            result.add(part.stack);
        }
        return result;
    }

    public RecipeSerializer<?> m_7707_() {
        return TGRecipeTypes.DISMANTLING.getSerializer();
    }

    public RecipeType<?> m_6671_() {
        return TGRecipeTypes.DISMANTLING.getType();
    }

    public record PartStack(ItemStack stack, float chance) {
    }
}

