/*
 * Decompiled with CFR 0.152.
 */
package ho.artisan.tgears.ponder.scene;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.controller.MelterBlock;
import slimeknights.tconstruct.smeltery.block.entity.CastingBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.FaucetBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.controller.MelterBlockEntity;

public class MelterScene {
    private MelterScene() {
    }

    public static void basic(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("basic_melter", "Building the basic smeltery");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        Selection smeltery = util.select().fromTo(2, 1, 2, 2, 2, 2);
        Selection basin = util.select().fromTo(1, 1, 2, 1, 2, 2);
        Selection table = util.select().fromTo(3, 1, 2, 3, 2, 2);
        BlockPos melter = util.grid().at(2, 2, 2);
        scene.idle(5);
        scene.world().showSection(util.select().position(melter.m_7495_()), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(melter), Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(40).text("Your first smeltery").placeNearTarget().attachKeyFrame().colored(PonderPalette.GREEN).pointAt(util.vector().topOf(melter));
        scene.idle(5);
        scene.overlay().showOutline(PonderPalette.GREEN, (Object)smeltery, util.select().fromTo(2, 1, 2, 2, 2, 2), 40);
        scene.idle(5);
        scene.overlay().showText(40).text("Need a heater to provide heat").placeNearTarget().colored(PonderPalette.MEDIUM).pointAt(util.vector().blockSurface(melter.m_7495_(), Direction.WEST));
        scene.idle(45);
        scene.overlay().showText(40).text("You still add some fuel to start the smeltery").placeNearTarget().attachKeyFrame().colored(PonderPalette.MEDIUM).pointAt(util.vector().blockSurface(melter.m_7495_(), Direction.WEST));
        scene.idle(45);
        scene.overlay().showControls(util.vector().blockSurface(melter.m_7495_(), Direction.NORTH), Pointing.RIGHT, 20).withItem(new ItemStack((ItemLike)Items.f_42413_));
        scene.world().modifyBlock(melter.m_7495_(), block -> (BlockState)block.m_61124_((Property)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), false);
        scene.idle(25);
        scene.overlay().showText(40).text("Or you can use fuel tank").attachKeyFrame().placeNearTarget().colored(PonderPalette.GREEN).pointAt(util.vector().blockSurface(melter.m_7495_(), Direction.WEST));
        scene.idle(25);
        scene.world().destroyBlock(melter.m_7495_());
        scene.idle(5);
        scene.world().setBlock(melter.m_7495_(), ((SearedTankBlock)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.FUEL_TANK)).m_49966_(), false);
        scene.idle(20);
        scene.overlay().showControls(util.vector().blockSurface(melter.m_7495_(), Direction.NORTH), Pointing.RIGHT, 20).rightClick().withItem(new ItemStack((ItemLike)Items.f_42448_));
        scene.world().modifyBlockEntity(melter.m_7495_(), TankBlockEntity.class, tank -> tank.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> handler.fill(new FluidStack((Fluid)Fluids.f_76195_, 4000), IFluidHandler.FluidAction.EXECUTE)));
        scene.overlay().showText(25).text("Also, don't forget to add fuel like lava").attachKeyFrame().placeNearTarget().colored(PonderPalette.MEDIUM).pointAt(util.vector().blockSurface(melter.m_7495_(), Direction.WEST));
        scene.idle(30);
        scene.overlay().showText(20).text("Finally, install the casting parts").attachKeyFrame().placeNearTarget().colored(PonderPalette.MEDIUM).pointAt(util.vector().blockSurface(melter, Direction.UP));
        scene.idle(30);
        scene.world().showSection(basin, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(table, Direction.DOWN);
        scene.idle(20);
        scene.markAsFinished();
    }

    public static void burner(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("basic_melter_burner", "Use the Blaze Burner to heat");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().everywhere(), Direction.UP);
        BlockPos melter = util.grid().at(2, 2, 2);
        Selection selection = util.select().fromTo(melter.m_7495_(), melter);
        scene.idle(15);
        scene.overlay().showOutline(PonderPalette.GREEN, (Object)selection, selection, 40);
        scene.idle(5);
        scene.overlay().showText(25).text("This is also a correct structure").placeNearTarget().attachKeyFrame().colored(PonderPalette.GREEN).pointAt(util.vector().blockSurface(melter, Direction.WEST));
        scene.idle(35);
        scene.overlay().showText(25).text("Provide 400\u00b0C temperature and half the rate when extinguished").placeNearTarget().attachKeyFrame().colored(PonderPalette.MEDIUM).pointAt(util.vector().blockSurface(melter.m_7495_(), Direction.WEST));
        scene.idle(45);
        scene.overlay().showControls(util.vector().blockSurface(melter.m_7495_(), Direction.NORTH), Pointing.RIGHT, 15).rightClick().withItem(new ItemStack((ItemLike)Items.f_42647_));
        scene.idle(7);
        scene.world().modifyBlock(melter.m_7495_(), s -> (BlockState)s.m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.KINDLED), false);
        scene.idle(20);
        scene.overlay().showText(25).text("Provide 800\u00b0C temperature and normal rate when kindled").placeNearTarget().attachKeyFrame().colored(PonderPalette.MEDIUM).pointAt(util.vector().blockSurface(melter.m_7495_(), Direction.WEST));
        scene.idle(45);
        scene.overlay().showControls(util.vector().blockSurface(melter.m_7495_(), Direction.NORTH), Pointing.RIGHT, 15).rightClick().withItem(AllItems.BLAZE_CAKE.asStack());
        scene.idle(7);
        scene.world().modifyBlock(melter.m_7495_(), s -> (BlockState)s.m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SEETHING), false);
        scene.idle(20);
        scene.overlay().showText(25).text("Provide 1600\u00b0C temperature and double the rate when seething").placeNearTarget().attachKeyFrame().colored(PonderPalette.MEDIUM).pointAt(util.vector().blockSurface(melter.m_7495_(), Direction.WEST));
        scene.idle(60);
        scene.markAsFinished();
    }

    public static void casting(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("basic_melter_casting", "Melting and Casting");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().everywhere(), Direction.UP);
        BlockPos table = util.grid().at(1, 1, 2);
        BlockPos basin = util.grid().at(3, 1, 2);
        BlockPos melter = util.grid().at(2, 2, 2);
        scene.idle(5);
        scene.overlay().showText(20).text("Melting to get molten material").attachKeyFrame().placeNearTarget().colored(PonderPalette.MEDIUM).pointAt(util.vector().blockSurface(melter.m_7494_(), Direction.UP));
        scene.idle(30);
        ElementLink itemLink = scene.world().createItemEntity(melter.m_6630_(2).m_252807_(), util.vector().of(0.0, 0.1, 0.0), new ItemStack((ItemLike)Items.f_151053_));
        scene.idle(10);
        scene.world().modifyEntity(itemLink, Entity::m_146870_);
        scene.world().modifyBlockEntity(melter, MelterBlockEntity.class, m -> m.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> handler.insertItem(0, new ItemStack((ItemLike)Items.f_151053_), false)));
        scene.world().modifyBlock(melter, block -> (BlockState)block.m_61124_((Property)MelterBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), false);
        scene.idle(10);
        scene.overlay().showText(20).text("Waiting to melt").attachKeyFrame().placeNearTarget().colored(PonderPalette.MEDIUM).pointAt(util.vector().blockSurface(melter, Direction.NORTH));
        scene.idle(30);
        scene.world().modifyBlockEntity(melter, MelterBlockEntity.class, m -> {
            m.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> handler.extractItem(0, 1, false));
            m.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> handler.fill(new FluidStack(TinkerFluids.moltenGold.get(), 120), IFluidHandler.FluidAction.EXECUTE));
        });
        scene.world().modifyBlock(melter, block -> (BlockState)block.m_61124_((Property)MelterBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), false);
        scene.idle(5);
        scene.world().hideSection(util.select().position(melter.m_7494_()), Direction.UP);
        scene.idle(10);
        scene.overlay().showControls(util.vector().blockSurface(table.m_7494_(), Direction.EAST), Pointing.RIGHT, 20).rightClick();
        for (int i = 0; i < 4; ++i) {
            scene.world().modifyBlockEntity(table.m_7494_(), FaucetBlockEntity.class, f -> f.onActivationPacket(new FluidStack(TinkerFluids.moltenGold.get(), 30), true));
            scene.world().modifyBlockEntity(melter, MelterBlockEntity.class, m -> m.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> handler.drain(new FluidStack(TinkerFluids.moltenGold.get(), 30), IFluidHandler.FluidAction.EXECUTE)));
            scene.world().modifyBlockEntity(table, CastingBlockEntity.Table.class, t -> t.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> handler.fill(new FluidStack(TinkerFluids.moltenGold.get(), 30), IFluidHandler.FluidAction.EXECUTE)));
            scene.idle(5);
        }
        scene.idle(10);
        scene.world().modifyBlockEntity(table.m_7494_(), FaucetBlockEntity.class, f -> f.onActivationPacket(new FluidStack(TinkerFluids.moltenGold.get(), 0), false));
        scene.idle(45);
        scene.world().modifyBlockEntity(table, CastingBlockEntity.Table.class, t -> t.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> handler.getStackInSlot(0).m_41764_(0)));
        scene.idle(60);
        scene.markAsFinished();
    }

    public static void pipe(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("basic_melter_pipe", "Using fluid pipes while casting");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        Selection table = util.select().fromTo(1, 1, 1, 3, 1, 1);
        Selection smeltery = util.select().fromTo(3, 1, 3, 3, 2, 3);
        BlockPos basic = util.grid().at(3, 2, 3);
        BlockPos cog = util.grid().at(2, 3, 3);
        BlockPos casting = util.grid().at(2, 1, 1);
        scene.idle(5);
        scene.world().showSection(smeltery, Direction.UP);
        scene.idle(5);
        scene.world().showSection(table, Direction.UP);
        scene.idle(10);
        scene.rotateCameraY(90.0f);
        scene.idle(25);
        scene.overlay().showText(25).text("Besides the Faucets, you can also use the Pipe for casting").placeNearTarget().attachKeyFrame().colored(PonderPalette.MEDIUM).pointAt(util.vector().blockSurface(basic, Direction.UP));
        scene.idle(35);
        scene.world().showSection(util.select().position(basic.m_122025_(1)), Direction.WEST);
        scene.idle(5);
        scene.world().showSection(util.select().position(basic.m_122025_(2)), Direction.WEST);
        BlockPos pipe = basic.m_122025_(2).m_122013_(2);
        scene.idle(5);
        scene.world().showSection(util.select().position(pipe.m_122019_()), Direction.WEST);
        scene.idle(5);
        scene.world().showSection(util.select().position(pipe), Direction.WEST);
        scene.idle(5);
        scene.world().showSection(util.select().position(pipe.m_122030_(1)), Direction.WEST);
        scene.idle(5);
        scene.world().showSection(util.select().position(pipe.m_122030_(2)), Direction.WEST);
        scene.idle(5);
        scene.rotateCameraY(-90.0f);
        scene.idle(25);
        scene.world().showSection(util.select().position(cog), Direction.SOUTH);
        scene.idle(5);
        scene.world().showSection(util.select().position(cog.m_122024_()), Direction.SOUTH);
        scene.idle(5);
        scene.overlay().showControls(cog.m_122024_().m_252807_(), Pointing.DOWN, 20).rightClick();
        scene.idle(7);
        scene.world().setKineticSpeed(util.select().everywhere(), 32.0f);
        scene.world().modifyKineticSpeed(util.select().position(cog.m_7495_()), s -> Float.valueOf(s.floatValue() * -1.0f));
        scene.effects().rotationDirectionIndicator(cog.m_122024_());
        scene.idle(25);
        scene.overlay().showText(25).text("The pipe will transport the fluid to the casting container").placeNearTarget().attachKeyFrame().colored(PonderPalette.MEDIUM).pointAt(util.vector().blockSurface(basic.m_122024_(), Direction.NORTH));
        scene.idle(35);
        scene.world().modifyBlockEntity(basic, MelterBlockEntity.class, m -> m.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> handler.drain(new FluidStack(TinkerFluids.moltenIron.get(), 90), IFluidHandler.FluidAction.EXECUTE)));
        scene.world().modifyBlockEntity(casting.m_122029_(), CastingBlockEntity.Table.class, t -> t.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> handler.fill(new FluidStack(TinkerFluids.moltenIron.get(), 90), IFluidHandler.FluidAction.EXECUTE)));
        scene.idle(15);
        scene.world().modifyBlockEntity(basic, MelterBlockEntity.class, m -> m.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> handler.drain(new FluidStack(TinkerFluids.moltenIron.get(), 90), IFluidHandler.FluidAction.EXECUTE)));
        scene.world().modifyBlockEntity(casting, CastingBlockEntity.Table.class, t -> t.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> handler.fill(new FluidStack(TinkerFluids.moltenIron.get(), 90), IFluidHandler.FluidAction.EXECUTE)));
        scene.idle(15);
        scene.world().modifyBlockEntity(basic, MelterBlockEntity.class, m -> m.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> handler.drain(new FluidStack(TinkerFluids.moltenIron.get(), 180), IFluidHandler.FluidAction.EXECUTE)));
        scene.world().modifyBlockEntity(casting.m_122024_(), CastingBlockEntity.Table.class, t -> t.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> handler.fill(new FluidStack(TinkerFluids.moltenIron.get(), 180), IFluidHandler.FluidAction.EXECUTE)));
        scene.idle(15);
        scene.world().hideSection(util.select().position(pipe), Direction.WEST);
        scene.idle(5);
        scene.world().hideSection(util.select().position(pipe.m_122030_(1)), Direction.WEST);
        scene.idle(5);
        scene.world().hideSection(util.select().position(pipe.m_122030_(2)), Direction.WEST);
        scene.idle(60);
        scene.markAsFinished();
    }

    public static void spout(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("basic_melter_spout", "Using spout while casting");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        BlockPos table = util.grid().at(2, 1, 1);
        BlockPos spout = util.grid().at(2, 3, 1);
        BlockPos melter = util.grid().at(2, 2, 3);
        BlockPos godHand = util.grid().at(1, 2, 2);
        Selection cog = util.select().fromTo(1, 3, 1, 1, 3, 2);
        scene.idle(5);
        scene.world().showSection(util.select().position(melter.m_7495_()), Direction.NORTH);
        scene.idle(5);
        scene.world().showSection(util.select().position(melter), Direction.NORTH);
        scene.idle(5);
        scene.world().showSection(util.select().position(table), Direction.UP);
        scene.idle(15);
        scene.overlay().showText(25).text("The table is actually a fluid container").placeNearTarget().attachKeyFrame().colored(PonderPalette.MEDIUM).pointAt(util.vector().blockSurface(table, Direction.UP));
        scene.idle(35);
        scene.world().showSection(util.select().position(melter.m_7494_()), Direction.UP);
        scene.idle(5);
        scene.world().showSection(util.select().position(spout.m_122019_()), Direction.UP);
        scene.idle(5);
        scene.world().showSection(util.select().position(spout), Direction.UP);
        scene.idle(5);
        scene.overlay().showText(25).text("So spout can be used to cast").placeNearTarget().attachKeyFrame().colored(PonderPalette.MEDIUM).pointAt(util.vector().blockSurface(spout, Direction.UP));
        scene.idle(35);
        scene.world().showSection(cog, Direction.UP);
        scene.idle(5);
        scene.overlay().showControls(godHand.m_252807_(), Pointing.LEFT, 20).rightClick();
        scene.idle(7);
        scene.world().setKineticSpeed(util.select().everywhere(), 32.0f);
        scene.world().modifyKineticSpeed(util.select().position(spout.m_122019_()), f -> Float.valueOf(f.floatValue() * -1.0f));
        scene.effects().rotationDirectionIndicator(godHand);
        scene.idle(35);
        for (int i = 0; i < 5; ++i) {
            scene.world().modifyBlockEntity(melter, MelterBlockEntity.class, m -> m.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> handler.drain(new FluidStack(TinkerFluids.moltenIron.get(), 200), IFluidHandler.FluidAction.EXECUTE)));
            scene.world().modifyBlockEntity(spout, SpoutBlockEntity.class, s -> s.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> handler.fill(new FluidStack(TinkerFluids.moltenIron.get(), 200), IFluidHandler.FluidAction.EXECUTE)));
            scene.idle(5);
        }
        scene.idle(60);
        scene.markAsFinished();
    }
}

