/*
 * Decompiled with CFR 0.152.
 */
package ho.artisan.tgears.util;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import ho.artisan.tgears.TinkersGearsConfig;
import ho.artisan.tgears.util.TinkerGogglesUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import slimeknights.tconstruct.smeltery.block.entity.module.SolidFuelModule;

public final class BlazeBurnerUtil {
    private BlazeBurnerUtil() {
    }

    public static float getFactor(BlazeBurnerBlock.HeatLevel level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case BlazeBurnerBlock.HeatLevel.NONE -> 0.0f;
            case BlazeBurnerBlock.HeatLevel.SMOULDERING -> ((Float)TinkersGearsConfig.EXTINGUISHED_FACTOR.get()).floatValue();
            case BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> ((Float)TinkersGearsConfig.KINDLED_FACTOR.get()).floatValue();
            case BlazeBurnerBlock.HeatLevel.SEETHING -> ((Float)TinkersGearsConfig.SEETHING_FACTOR.get()).floatValue();
        };
    }

    public static int getTemperature(BlazeBurnerBlock.HeatLevel level) {
        return (int)(BlazeBurnerUtil.getFactor(level) * 800.0f);
    }

    public static int getRate(BlazeBurnerBlock.HeatLevel level) {
        return (int)(BlazeBurnerUtil.getFactor(level) * 10.0f);
    }

    public static void addToGoggleTooltip(List<Component> tooltip, SolidFuelModule module) {
        TinkerGogglesUtil.addTemperature(tooltip, module.getTemperature());
        TinkerGogglesUtil.addRate(tooltip, module.getRate() * 10);
    }
}

