/*
 * Decompiled with CFR 0.152.
 */
package ho.artisan.tgears.util;

import com.simibubi.create.foundation.utility.CreateLang;
import ho.artisan.tgears.index.TGModifiers;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public final class TinkerGogglesUtil {
    private TinkerGogglesUtil() {
    }

    public static boolean isWearingGoggles(Player player) {
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        if (head.m_41720_() instanceof IModifiable) {
            ToolStack tool = ToolStack.from((ItemStack)head.m_41777_());
            return tool.getModifier(TGModifiers.Ids.GOGGLES).getLevel() > 0;
        }
        return false;
    }

    public static void addStats(List<Component> tooltip) {
        CreateLang.translate((String)"tooltip.gears.tinker_stats", (Object[])new Object[0]).forGoggles(tooltip);
    }

    public static void addFluidStats(List<Component> tooltip) {
        CreateLang.translate((String)"tooltip.gears.tinker_stats.fluid", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
    }

    public static void addTemperature(List<Component> tooltip, int temperature) {
        CreateLang.translate((String)"tooltip.gears.temperature", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.number((double)temperature).translate("generic.unit.temperature", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_heating", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
    }

    public static void addRate(List<Component> tooltip, int rate) {
        CreateLang.translate((String)"tooltip.gears.rate", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.number((double)rate).translate("generic.unit.percent", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_heating", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
    }

    public static void addFluid(List<Component> tooltip, FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return;
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CreateLang.text((String)"").add(CreateLang.fluidName((FluidStack)fluidStack).add(CreateLang.text((String)" ")).style(ChatFormatting.GRAY).add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
    }

    public static void addProgress(List<Component> tooltip, int progress, int maxProgress) {
        CreateLang.translate((String)"tooltip.gears.progress", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        int d = (int)((double)progress / (double)maxProgress * 100.0);
        CreateLang.number((double)d).translate("generic.unit.percent", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_recipe", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
    }

    public static void addOutput(List<Component> tooltip, ItemStack output) {
        CreateLang.translate((String)"tooltip.gears.output", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.itemName((ItemStack)output).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
    }
}

