/*
 * Decompiled with CFR 0.152.
 */
package freelook.freelook.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import freelook.freelook.FreeLookMod;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5498;

public class FreeLookConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private boolean isToggle = false;
    private int perspective = 3;
    private boolean isBlocked = false;
    private List<String> blockList = new ArrayList<String>(List.of("play.hypixel.net", "mc.hypixel.net"));

    public List<String> getBlockList() {
        return this.blockList;
    }

    public synchronized boolean isToggle() {
        return this.isToggle;
    }

    public synchronized void setToggle(boolean toggle) {
        this.isToggle = toggle;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean blocked) {
        this.isBlocked = blocked;
    }

    public synchronized void nextPerspective() {
        this.perspective = switch (this.perspective) {
            case 1 -> 2;
            case 3 -> 1;
            default -> 3;
        };
    }

    public synchronized class_5498 getPerspective() {
        return switch (this.perspective) {
            case 1 -> class_5498.field_26664;
            case 2 -> class_5498.field_26666;
            default -> class_5498.field_26665;
        };
    }

    public synchronized void setPerspective(int perspective) {
        this.perspective = class_3532.method_15340((int)perspective, (int)1, (int)3);
    }

    public void save() {
        File folder = new File(class_310.method_1551().field_1697, "config");
        if (!folder.isDirectory() && !folder.mkdirs()) {
            FreeLookMod.LOGGER.error("Failed to create missing config folder");
            return;
        }
        File file = new File(folder, "freeLook.json");
        try (FileWriter fw = new FileWriter(file);){
            GSON.toJson((Object)this, FreeLookConfig.class, (Appendable)fw);
            FreeLookMod.LOGGER.info("Saved config");
        }
        catch (Exception e) {
            FreeLookMod.LOGGER.error("Failed to write file {}", (Object)file.getName(), (Object)e);
        }
    }

    public void reset() {
        this.setToggle(false);
        this.setPerspective(3);
    }

    public void load() {
        File folder = new File(class_310.method_1551().field_1697, "config");
        File file = new File(folder, "freeLook.json");
        if (!file.exists()) {
            this.reset();
            return;
        }
        try (FileReader fr = new FileReader(file);){
            FreeLookConfig obj = (FreeLookConfig)GSON.fromJson((Reader)fr, FreeLookConfig.class);
            this.setPerspective(obj.perspective);
            this.setToggle(obj.isToggle);
            this.blockList = obj.blockList != null ? new ArrayList<String>(obj.blockList) : new ArrayList();
        }
        catch (Exception e) {
            FreeLookMod.LOGGER.error("Failed to read file {}", (Object)file.getName(), (Object)e);
        }
    }
}

