/*
 * Decompiled with CFR 0.152.
 */
package software.axios.libs.commandapi;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import software.axios.libs.commandapi.CommandPermission;
import software.axios.libs.commandapi.exceptions.InvalidCommandNameException;

final class CommandMetaData<CommandSender> {
    final String commandName;
    CommandPermission permission = CommandPermission.NONE;
    String[] aliases = new String[0];
    Predicate<CommandSender> requirements = s -> true;
    Optional<String> shortDescription = Optional.empty();
    Optional<String> fullDescription = Optional.empty();
    Optional<String[]> usageDescription = Optional.empty();
    Optional<Object> helpTopic = Optional.empty();

    CommandMetaData(String commandName) {
        if (commandName == null || commandName.isEmpty() || commandName.contains(" ")) {
            throw new InvalidCommandNameException(commandName);
        }
        this.commandName = commandName;
    }

    public CommandMetaData(CommandMetaData<CommandSender> original) {
        this(original.commandName);
        this.permission = original.permission;
        this.aliases = Arrays.copyOf(original.aliases, original.aliases.length);
        this.requirements = original.requirements;
        this.shortDescription = original.shortDescription.isPresent() ? Optional.of(original.shortDescription.get()) : Optional.empty();
        this.fullDescription = original.fullDescription.isPresent() ? Optional.of(original.fullDescription.get()) : Optional.empty();
        this.usageDescription = original.usageDescription.isPresent() ? Optional.of(original.usageDescription.get()) : Optional.empty();
        this.helpTopic = original.helpTopic.isPresent() ? Optional.of(original.helpTopic.get()) : Optional.empty();
    }
}

