/*
 * Decompiled with CFR 0.152.
 */
package software.axios.libs.commandapi;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import software.axios.libs.commandapi.BukkitTooltip;
import software.axios.libs.commandapi.CommandAPI;
import software.axios.libs.commandapi.CommandAPIBukkit;
import software.axios.libs.commandapi.exceptions.WrapperCommandSyntaxException;
import software.axios.libs.commandapi.nms.NMS;

public class PaperImplementations {
    private final boolean isPaperPresent;
    private final boolean isFoliaPresent;
    private final boolean isPaperBrigAPI;
    private final NMS<?> nmsInstance;
    private final Class<? extends CommandSender> feedbackForwardingCommandSender;
    private final Class<? extends CommandSender> nullCommandSender;

    public PaperImplementations(boolean isPaperPresent, boolean isFoliaPresent, NMS<?> nmsInstance) {
        boolean paperCommandSourceStackPresent;
        this.isPaperPresent = isPaperPresent;
        this.isFoliaPresent = isFoliaPresent;
        this.nmsInstance = nmsInstance;
        Class<?> tempFeedbackForwardingCommandSender = null;
        try {
            tempFeedbackForwardingCommandSender = Class.forName("io.papermc.paper.commands.FeedbackForwardingSender");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.feedbackForwardingCommandSender = tempFeedbackForwardingCommandSender;
        Class<?> tempNullCommandSender = null;
        try {
            tempNullCommandSender = Class.forName("io.papermc.paper.brigadier.NullCommandSender");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.nullCommandSender = tempNullCommandSender;
        try {
            Class.forName("io.papermc.paper.command.brigadier.CommandSourceStack");
            paperCommandSourceStackPresent = true;
        }
        catch (ClassNotFoundException e) {
            paperCommandSourceStackPresent = false;
        }
        this.isPaperBrigAPI = paperCommandSourceStackPresent;
    }

    public void registerReloadHandler(Plugin plugin) {
        if (this.isPaperPresent) {
            Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onServerReloadResources(ServerResourcesReloadedEvent event) {
                    CommandAPIBukkit.get().getCommandRegistrationStrategy().preReloadDataPacks();
                    if (!CommandAPIBukkit.getConfiguration().shouldHookPaperReload()) {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            player.updateCommands();
                        }
                        return;
                    }
                    CommandAPI.logNormal("/minecraft:reload detected. Reloading CommandAPI commands!");
                    PaperImplementations.this.nmsInstance.reloadDataPacks();
                }
            }, plugin);
            CommandAPI.logNormal("Hooked into Paper ServerResourcesReloadedEvent");
        } else {
            CommandAPI.logNormal("Did not hook into Paper ServerResourcesReloadedEvent");
        }
    }

    public CommandMap getCommandMap() {
        if (this.isPaperPresent) {
            return Bukkit.getServer().getCommandMap();
        }
        return this.nmsInstance.getSimpleCommandMap();
    }

    public boolean isPaperPresent() {
        return this.isPaperPresent;
    }

    public boolean isPaperBrigAPI() {
        return this.isPaperBrigAPI;
    }

    public boolean isFoliaPresent() {
        return this.isFoliaPresent;
    }

    public Class<? extends CommandSender> getFeedbackForwardingCommandSender() {
        return this.feedbackForwardingCommandSender;
    }

    public Class<? extends CommandSender> getNullCommandSender() {
        return this.nullCommandSender;
    }

    public WrapperCommandSyntaxException getExceptionFromString(String message) {
        Message brigadierMessage = this.isPaperPresent ? BukkitTooltip.messageFromAdventureComponent((ComponentLike)LegacyComponentSerializer.legacySection().deserialize(message)) : BukkitTooltip.messageFromBaseComponents(TextComponent.fromLegacyText((String)message));
        return new WrapperCommandSyntaxException(new SimpleCommandExceptionType(brigadierMessage).create());
    }
}

