/*
 * Decompiled with CFR 0.152.
 */
package software.axios.libs.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import software.axios.libs.commandapi.arguments.CommandAPIArgumentType;
import software.axios.libs.commandapi.arguments.SafeOverrideableArgument;
import software.axios.libs.commandapi.exceptions.InvalidRangeException;
import software.axios.libs.commandapi.executors.CommandArguments;

public class IntegerArgument
extends SafeOverrideableArgument<Integer, Integer> {
    public IntegerArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)IntegerArgumentType.integer(), String::valueOf);
    }

    public IntegerArgument(String nodeName, int min) {
        super(nodeName, (ArgumentType<?>)IntegerArgumentType.integer((int)min), String::valueOf);
    }

    public IntegerArgument(String nodeName, int min, int max) {
        super(nodeName, (ArgumentType<?>)IntegerArgumentType.integer((int)min, (int)max), String::valueOf);
        if (max < min) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Integer> getPrimitiveType() {
        return Integer.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_INTEGER;
    }

    @Override
    public <Source> Integer parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return (Integer)cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

