/*
 * Decompiled with CFR 0.152.
 */
package software.axios.libs.commandapi.network;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import software.axios.libs.commandapi.network.BukkitPacketHandlerProvider;
import software.axios.libs.commandapi.network.CommandAPIMessenger;
import software.axios.libs.commandapi.network.CommandAPIProtocol;
import software.axios.libs.commandapi.network.packets.SetVersionPacket;

public class BukkitCommandAPIMessenger
extends CommandAPIMessenger<Player, Player>
implements PluginMessageListener,
Listener {
    private final JavaPlugin plugin;
    private final Map<Player, Integer> protocolVersionPerPlayer;

    public BukkitCommandAPIMessenger(JavaPlugin plugin) {
        super(new BukkitPacketHandlerProvider());
        this.plugin = plugin;
        this.protocolVersionPerPlayer = new HashMap<Player, Integer>();
        Messenger messenger = Bukkit.getServer().getMessenger();
        for (String channelIdentifier : CommandAPIProtocol.getAllChannelIdentifiers()) {
            messenger.registerIncomingPluginChannel((Plugin)this.plugin, channelIdentifier, (PluginMessageListener)this);
            messenger.registerOutgoingPluginChannel((Plugin)this.plugin, channelIdentifier);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler
    public void onPlayerRegisterChannel(PlayerRegisterChannelEvent event) {
        if (!event.getChannel().equals(CommandAPIProtocol.HANDSHAKE.getChannelIdentifier())) {
            return;
        }
        this.sendPacket(event.getPlayer(), new SetVersionPacket(1));
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        this.protocolVersionPerPlayer.remove(event.getPlayer());
    }

    @Override
    public void close() {
        Messenger messenger = Bukkit.getServer().getMessenger();
        for (String channelIdentifier : CommandAPIProtocol.getAllChannelIdentifiers()) {
            messenger.unregisterIncomingPluginChannel((Plugin)this.plugin, channelIdentifier);
            messenger.unregisterOutgoingPluginChannel((Plugin)this.plugin, channelIdentifier);
        }
        HandlerList.unregisterAll((Listener)this);
    }

    public void setProtocolVersion(Player sender, int protocolVersion) {
        this.protocolVersionPerPlayer.put(sender, protocolVersion);
    }

    @Override
    public int getConnectionProtocolVersion(Player target) {
        return this.protocolVersionPerPlayer.getOrDefault(target, 0);
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte[] message) {
        CommandAPIProtocol protocol = CommandAPIProtocol.getProtocolForChannel(channel);
        if (protocol == null) {
            return;
        }
        this.messageReceived(protocol, player, message);
    }

    @Override
    public void sendRawBytes(CommandAPIProtocol protocol, Player target, byte[] bytes) {
        target.sendPluginMessage((Plugin)this.plugin, protocol.getChannelIdentifier(), bytes);
    }
}

