/*
 * Decompiled with CFR 0.152.
 */
package software.axios.libs.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.ScoreboardSlotArgument;
import net.minecraft.commands.arguments.TeamArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.particles.TrailParticleOption;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionLibrary;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.ScoreHolder;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.CraftLootTable;
import org.bukkit.craftbukkit.CraftParticle;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.help.CustomHelpTopic;
import org.bukkit.craftbukkit.help.SimpleHelpMap;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.potion.CraftPotionEffectType;
import org.bukkit.entity.Entity;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;
import software.axios.libs.commandapi.CommandAPI;
import software.axios.libs.commandapi.CommandAPIHandler;
import software.axios.libs.commandapi.CommandRegistrationStrategy;
import software.axios.libs.commandapi.PaperCommandRegistration;
import software.axios.libs.commandapi.SafeVarHandle;
import software.axios.libs.commandapi.SpigotCommandRegistration;
import software.axios.libs.commandapi.arguments.ArgumentSubType;
import software.axios.libs.commandapi.arguments.SuggestionProviders;
import software.axios.libs.commandapi.commandsenders.AbstractCommandSender;
import software.axios.libs.commandapi.commandsenders.BukkitCommandSender;
import software.axios.libs.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import software.axios.libs.commandapi.nms.NMS_Common;
import software.axios.libs.commandapi.nms.NativeProxyCommandSender_1_21_R5;
import software.axios.libs.commandapi.wrappers.ComplexRecipeImpl;
import software.axios.libs.commandapi.wrappers.FloatRange;
import software.axios.libs.commandapi.wrappers.FunctionWrapper;
import software.axios.libs.commandapi.wrappers.IntegerRange;
import software.axios.libs.commandapi.wrappers.Location2D;
import software.axios.libs.commandapi.wrappers.NativeProxyCommandSender;
import software.axios.libs.commandapi.wrappers.ParticleData;
import software.axios.libs.commandapi.wrappers.Rotation;
import software.axios.libs.commandapi.wrappers.ScoreboardSlot;
import software.axios.libs.commandapi.wrappers.SimpleFunctionWrapper;

public class NMS_1_21_R5
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final Field entitySelectorUsesSelector;
    private static final Field serverFunctionLibraryDispatcher;
    private static final MethodHandle minecraftServerSetSelected;
    private static final boolean vanillaCommandDispatcherFieldExists;
    private static final SafeVarHandle<MinecraftServer, FuelValues> minecraftServerFuelValues;
    private static final CommandBuildContext COMMAND_BUILD_CONTEXT;

    private String toJson(net.minecraft.network.chat.Component component) {
        MinecraftServer server = (MinecraftServer)this.getMinecraftServer();
        RegistryAccess.Frozen access = server.registryAccess();
        RegistryOps ops = access.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        JsonElement element = (JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)ops, (Object)component).getOrThrow(s -> new RuntimeException("Failed to encode Minecraft Component: " + String.valueOf(component) + "; " + s));
        return new Gson().toJson(element);
    }

    private net.minecraft.network.chat.Component fromJson(String json) {
        Pair result = (Pair)ComponentSerialization.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)json)).getOrThrow(s -> new RuntimeException("Failed to decode Component: " + json + "; " + s));
        return (net.minecraft.network.chat.Component)result.getFirst();
    }

    @Override
    protected CommandBuildContext getCommandBuildContext() {
        return COMMAND_BUILD_CONTEXT;
    }

    @Override
    public ArgumentType<?> _ArgumentAdvancement() {
        return ResourceKeyArgument.key((ResourceKey)Registries.ADVANCEMENT);
    }

    @Override
    public ArgumentType<?> _ArgumentChatComponent() {
        return ComponentArgument.textComponent((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentEnchantment() {
        return ResourceArgument.resource((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.ENCHANTMENT);
    }

    @Override
    public ArgumentType<?> _ArgumentRecipe() {
        return ResourceKeyArgument.key((ResourceKey)Registries.RECIPE);
    }

    @Override
    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return ResourceArgument.resource((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.BIOME);
    }

    @Override
    public final Map<String, HelpTopic> getHelpMap() {
        return helpMapTopics.get((SimpleHelpMap)Bukkit.getHelpMap());
    }

    @Override
    public String[] compatibleVersions() {
        return new String[]{"1.21.6", "1.21.7", "1.21.8"};
    }

    private static String serializeNMSItemStack(ItemStack is) {
        return new ItemInput(is.getItemHolder(), is.getComponentsPatch()).serialize((HolderLookup.Provider)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final String convert(org.bukkit.inventory.ItemStack is) {
        return NMS_1_21_R5.serializeNMSItemStack(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)is));
    }

    @Override
    public final String convert(ParticleData<?> particle) {
        ParticleOptions particleOptions = CraftParticle.createParticleParam((Particle)particle.particle(), particle.data());
        ResourceLocation particleKey = BuiltInRegistries.PARTICLE_TYPE.getKey((Object)particleOptions.getType());
        Codec codec = particleOptions.getType().codec().codec();
        DataResult result = codec.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)particleOptions);
        CompoundTag particleOptionsTag = (CompoundTag)result.result().get();
        String dataString = particleOptionsTag.keySet().isEmpty() ? "" : particleOptionsTag.toString();
        return particleKey.toString() + dataString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int runCommandFunction(CommandFunction<CommandSourceStack> commandFunction, CommandSourceStack css) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push(() -> "function " + String.valueOf(commandFunction.id()));
        AtomicInteger result = new AtomicInteger();
        CommandResultCallback onCommandResult = (succeeded, resultValue) -> result.set(resultValue);
        try {
            InstantiatedFunction instantiatedFunction = commandFunction.instantiate((CompoundTag)null, this.getBrigadierDispatcher());
            Commands.executeCommandInContext((CommandSourceStack)css, executioncontext -> ExecutionContext.queueInitialFunctionCall((ExecutionContext)executioncontext, (InstantiatedFunction)instantiatedFunction, (ExecutionCommandSource)css, (CommandResultCallback)onCommandResult));
        }
        catch (FunctionInstantiationException instantiatedFunction) {
        }
        catch (Exception exception) {
            LogUtils.getLogger().warn("Failed to execute function {}", (Object)commandFunction.id(), (Object)exception);
        }
        finally {
            profiler.pop();
        }
        return result.get();
    }

    private final SimpleFunctionWrapper convertFunction(CommandFunction<CommandSourceStack> commandFunction) {
        ToIntFunction<CommandSourceStack> appliedObj = css -> this.runCommandFunction(commandFunction, (CommandSourceStack)css);
        String[] commands = new String[]{};
        try {
            InstantiatedFunction instantiatedFunction = commandFunction.instantiate((CompoundTag)null, this.getBrigadierDispatcher());
            List cArr = instantiatedFunction.entries();
            commands = new String[cArr.size()];
            int size = cArr.size();
            for (int i = 0; i < size; ++i) {
                commands[i] = cArr.get(i).toString();
            }
        }
        catch (FunctionInstantiationException functionInstantiationException) {
            // empty catch block
        }
        return new SimpleFunctionWrapper(this.fromResourceLocation(commandFunction.id()), appliedObj, commands);
    }

    @Override
    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    @Override
    public Advancement getAdvancement(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return ResourceKeyArgument.getAdvancement(cmdCtx, (String)key).toBukkit();
    }

    @Override
    public Component getAdventureChat(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return GsonComponentSerializer.gson().deserialize((Object)this.toJson(MessageArgument.getMessage(cmdCtx, (String)key)));
    }

    @Override
    public NamedTextColor getAdventureChatColor(CommandContext<CommandSourceStack> cmdCtx, String key) {
        Integer color = ColorArgument.getColor(cmdCtx, (String)key).getColor();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.namedColor((int)color);
    }

    @Override
    public final Component getAdventureChatComponent(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return GsonComponentSerializer.gson().deserialize((Object)this.toJson(ComponentArgument.getResolvedComponent(cmdCtx, (String)key)));
    }

    @Override
    public final Object getBiome(CommandContext<CommandSourceStack> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        ResourceLocation resourceLocation = ResourceArgument.getResource(cmdCtx, (String)key, (ResourceKey)Registries.BIOME).key().location();
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)resourceLocation.getPath().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var5_7 = biome;
                yield var5_7;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var5_8;
                yield var5_8 = this.fromResourceLocation(resourceLocation);
            }
            default -> {
                NamespacedKey var5_9;
                yield var5_9 = null;
            }
        };
    }

    @Override
    public final BlockData getBlockState(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return CraftBlockData.fromData((BlockState)BlockStateArgument.getBlock(cmdCtx, (String)key).getState());
    }

    @Override
    public CommandSourceStack getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender.getSource());
    }

    @Override
    public final BaseComponent[] getChat(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)this.toJson(MessageArgument.getMessage(cmdCtx, (String)key)));
    }

    @Override
    public final BaseComponent[] getChatComponent(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)this.toJson(ComponentArgument.getResolvedComponent(cmdCtx, (String)key)));
    }

    @Override
    public final World getDimension(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return DimensionArgument.getDimension(cmdCtx, (String)key).getWorld();
    }

    @Override
    public final org.bukkit.enchantments.Enchantment getEnchantment(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Enchantment enchantment = (Enchantment)ResourceArgument.getEnchantment(cmdCtx, (String)key).value();
        ResourceLocation resource = ((MinecraftServer)this.getMinecraftServer()).registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getKey((Object)enchantment);
        return (org.bukkit.enchantments.Enchantment)Registry.ENCHANTMENT.get(this.fromResourceLocation(resource));
    }

    @Override
    public final Object getEntitySelector(CommandContext<CommandSourceStack> cmdCtx, String str, ArgumentSubType subType, boolean allowEmpty) throws CommandSyntaxException {
        Object object;
        EntitySelector argument = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            entitySelectorUsesSelector.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        switch (subType) {
            case ENTITYSELECTOR_MANY_ENTITIES: {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (net.minecraft.world.entity.Entity entity : argument.findEntities((CommandSourceStack)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw EntityArgument.NO_ENTITIES_FOUND.create();
                    }
                    ArrayList<CraftEntity> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_MANY_PLAYERS: {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (ServerPlayer player : argument.findPlayers((CommandSourceStack)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw EntityArgument.NO_PLAYERS_FOUND.create();
                    }
                    ArrayList<CraftPlayer> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_ONE_ENTITY: {
                CraftEntity craftEntity;
                object = craftEntity = argument.findSingleEntity((CommandSourceStack)cmdCtx.getSource()).getBukkitEntity();
                break;
            }
            case ENTITYSELECTOR_ONE_PLAYER: {
                CraftPlayer craftPlayer = argument.findSinglePlayer((CommandSourceStack)cmdCtx.getSource()).getBukkitEntity();
                object = craftPlayer;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
            }
        }
        return object;
    }

    @Override
    public FloatRange getFloatRange(CommandContext<CommandSourceStack> cmdCtx, String key) {
        MinMaxBounds.Doubles range = RangeArgument.Floats.getRange(cmdCtx, (String)key);
        Double lowBoxed = range.min().orElse(null);
        Double highBoxed = range.max().orElse(null);
        double low = lowBoxed == null ? -3.4028234663852886E38 : lowBoxed;
        double high = highBoxed == null ? 3.4028234663852886E38 : highBoxed;
        return new FloatRange((float)low, (float)high);
    }

    @Override
    public final FunctionWrapper[] getFunction(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandSourceStack css = ((CommandSourceStack)cmdCtx.getSource()).withSuppressedOutput().withMaximumPermission(2);
        for (CommandFunction commandFunction : FunctionArgument.getFunctions(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper(this.convertFunction((CommandFunction<CommandSourceStack>)commandFunction), css, entity -> ((CommandSourceStack)cmdCtx.getSource()).withEntity(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    @Override
    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)key.getKey());
        Optional commandFunctionOptional = ((MinecraftServer)this.getMinecraftServer()).getFunctions().get(resourceLocation);
        if (commandFunctionOptional.isPresent()) {
            return this.convertFunction((CommandFunction<CommandSourceStack>)((CommandFunction)commandFunctionOptional.get()));
        }
        throw new IllegalStateException("Failed to get defined function " + String.valueOf(key) + "! This should never happen - please report this to the CommandAPIdevelopers, we'd love to know how you got this error message!");
    }

    @Override
    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (ResourceLocation resourceLocation : ((MinecraftServer)this.getMinecraftServer()).getFunctions().getFunctionNames()) {
            result.add(this.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public IntegerRange getIntRange(CommandContext<CommandSourceStack> cmdCtx, String key) {
        MinMaxBounds.Ints range = RangeArgument.Ints.getRange(cmdCtx, (String)key);
        Integer lowBoxed = range.min().orElse(null);
        Integer highBoxed = range.max().orElse(null);
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    @Override
    public final org.bukkit.inventory.ItemStack getItemStack(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        ItemInput input = ItemArgument.getItem(cmdCtx, (String)key);
        ItemStack item = input.createItemStack(1, false);
        return CraftItemStack.asBukkitCopy((ItemStack)item);
    }

    @Override
    public final Predicate<org.bukkit.inventory.ItemStack> getItemStackPredicate(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        ItemPredicateArgument.Result predicate = ItemPredicateArgument.getItemPredicate(cmdCtx, (String)key);
        return arg_0 -> NMS_1_21_R5.lambda$getItemStackPredicate$7((Predicate)predicate, arg_0);
    }

    @Override
    public final Location2D getLocation2DPrecise(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Vec2 vecPos = Vec2Argument.getVec2(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), vecPos.x, vecPos.y);
    }

    @Override
    public final LootTable getLootTable(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return CraftLootTable.minecraftToBukkit((ResourceLocation)ResourceLocationArgument.getId(cmdCtx, (String)key));
    }

    @Override
    public NamespacedKey getMinecraftKey(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return this.fromResourceLocation(ResourceLocationArgument.getId(cmdCtx, (String)key));
    }

    @Override
    public final Objective getObjective(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        String objectiveName = ObjectiveArgument.getObjective(cmdCtx, (String)key).getName();
        return Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
    }

    @Override
    public final ParticleData<?> getParticle(CommandContext<CommandSourceStack> cmdCtx, String key) {
        Particle particle;
        ParticleOptions particleOptions = ParticleArgument.getParticle(cmdCtx, (String)key);
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            particle = CraftParticle.minecraftToBukkit((ParticleType)particleOptions.getType());
        } else {
            particle = null;
        }
        if (particleOptions instanceof SimpleParticleType) {
            return new ParticleData<Object>(particle, null);
        }
        if (particleOptions instanceof BlockParticleOption) {
            BlockParticleOption options = (BlockParticleOption)particleOptions;
            return new ParticleData<CraftBlockData>(particle, CraftBlockData.fromData((BlockState)options.getState()));
        }
        if (particleOptions instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions options = (DustColorTransitionOptions)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof DustParticleOptions) {
            DustParticleOptions options = (DustParticleOptions)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.getColor().x() * 255.0f)), (int)((int)(options.getColor().y() * 255.0f)), (int)((int)(options.getColor().z() * 255.0f)));
            return new ParticleData<Particle.DustOptions>(particle, new Particle.DustOptions(color, options.getScale()));
        }
        if (particleOptions instanceof ItemParticleOption) {
            ItemParticleOption options = (ItemParticleOption)particleOptions;
            return new ParticleData<org.bukkit.inventory.ItemStack>(particle, CraftItemStack.asBukkitCopy((ItemStack)options.getItem()));
        }
        if (particleOptions instanceof VibrationParticleOption) {
            VibrationParticleOption options = (VibrationParticleOption)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof ShriekParticleOption) {
            ShriekParticleOption options = (ShriekParticleOption)particleOptions;
            return new ParticleData<Integer>(particle, options.getDelay());
        }
        if (particleOptions instanceof SculkChargeParticleOptions) {
            SculkChargeParticleOptions options = (SculkChargeParticleOptions)particleOptions;
            return new ParticleData<Float>(particle, Float.valueOf(options.roll()));
        }
        if (particleOptions instanceof ColorParticleOption) {
            ColorParticleOption options = (ColorParticleOption)particleOptions;
            return this.getParticleDataAsColorParticleOption(particle, options);
        }
        if (particleOptions instanceof TrailParticleOption) {
            TrailParticleOption options = (TrailParticleOption)particleOptions;
            return this.getParticleDataAsTrailParticleOption(cmdCtx, particle, options);
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData<Object>(particle, null);
    }

    private ParticleData<Particle.Trail> getParticleDataAsTrailParticleOption(CommandContext<CommandSourceStack> cmdCtx, Particle particle, TrailParticleOption options) {
        ServerLevel level = ((CommandSourceStack)cmdCtx.getSource()).getLevel();
        Vec3 target = options.target();
        Location targetLocation = new Location((World)level.getWorld(), target.x, target.y, target.z);
        Color color = Color.fromARGB((int)options.color());
        return new ParticleData<Particle.Trail>(particle, new Particle.Trail(targetLocation, color, options.duration()));
    }

    private ParticleData<Color> getParticleDataAsColorParticleOption(Particle particle, ColorParticleOption options) {
        Color color = Color.fromARGB((int)((int)(options.getAlpha() * 255.0f)), (int)((int)(options.getRed() * 255.0f)), (int)((int)(options.getGreen() * 255.0f)), (int)((int)(options.getBlue() * 255.0f)));
        return new ParticleData<Color>(particle, color);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, DustColorTransitionOptions options) {
        Color color = Color.fromRGB((int)((int)(options.getFromColor().x() * 255.0f)), (int)((int)(options.getFromColor().y() * 255.0f)), (int)((int)(options.getFromColor().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.getToColor().x() * 255.0f)), (int)((int)(options.getToColor().y() * 255.0f)), (int)((int)(options.getToColor().z() * 255.0f)));
        return new ParticleData<Particle.DustTransition>(particle, new Particle.DustTransition(color, toColor, options.getScale()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<CommandSourceStack> cmdCtx, Particle particle, VibrationParticleOption options) {
        Vec3 origin = ((CommandSourceStack)cmdCtx.getSource()).getPosition();
        ServerLevel level = ((CommandSourceStack)cmdCtx.getSource()).getLevel();
        Location from = new Location((World)level.getWorld(), origin.x, origin.y, origin.z);
        PositionSource positionSource = options.getDestination();
        if (!(positionSource instanceof BlockPositionSource)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + String.valueOf(options.getDestination()));
            return new ParticleData<Object>(particle, null);
        }
        BlockPositionSource positionSource2 = (BlockPositionSource)positionSource;
        Vec3 to = (Vec3)positionSource2.getPosition((Level)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.x(), to.y(), to.z()));
        return new ParticleData<Vibration>(particle, new Vibration(from, (Vibration.Destination)destination, options.getArrivalInTicks()));
    }

    @Override
    public Object getPotionEffect(CommandContext<CommandSourceStack> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.POTION_EFFECT_POTION_EFFECT -> CraftPotionEffectType.minecraftToBukkit((MobEffect)((MobEffect)ResourceArgument.getMobEffect(cmdCtx, (String)key).value()));
            case ArgumentSubType.POTION_EFFECT_NAMESPACEDKEY -> this.fromResourceLocation(ResourceLocationArgument.getId(cmdCtx, (String)key));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public final Recipe getRecipe(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        RecipeHolder recipe = ResourceKeyArgument.getRecipe(cmdCtx, (String)key);
        return new ComplexRecipeImpl(this.fromResourceLocation(recipe.id().registry()), recipe.toBukkitRecipe());
    }

    @Override
    public final Rotation getRotation(CommandContext<CommandSourceStack> cmdCtx, String key) {
        Vec2 rotation = RotationArgument.getRotation(cmdCtx, (String)key).getRotation((CommandSourceStack)cmdCtx.getSource());
        return new Rotation(rotation.y, rotation.x);
    }

    @Override
    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft(ScoreboardSlotArgument.getDisplaySlot(cmdCtx, (String)key).id());
    }

    @Override
    public Collection<String> getScoreHolderMultiple(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Collection scoreHolders = ScoreHolderArgument.getNames(cmdCtx, (String)key);
        HashSet<String> scoreHolderNames = new HashSet<String>();
        for (ScoreHolder scoreHolder : scoreHolders) {
            scoreHolderNames.add(scoreHolder.getScoreboardName());
        }
        return scoreHolderNames;
    }

    @Override
    public String getScoreHolderSingle(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return ScoreHolderArgument.getName(cmdCtx, (String)key).getScoreboardName();
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandSourceStack> cmdCtx, boolean isNative) {
        net.minecraft.world.entity.Entity proxyEntity;
        CraftEntity proxy;
        CommandSourceStack css = (CommandSourceStack)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        CraftEntity craftEntity = proxy = (proxyEntity = css.getEntity()) == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals((Object)proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender_1_21_R5(css, sender, (CommandSender)proxy));
        }
        return this.wrapCommandSender(sender);
    }

    @Override
    public NativeProxyCommandSender createNativeProxyCommandSender(CommandSender caller, CommandSender callee, Location location, World world) {
        if (callee == null) {
            callee = caller;
        }
        CommandSourceStack css = this.getBrigadierSourceFromCommandSender((AbstractCommandSender<? extends CommandSender>)this.wrapCommandSender(caller));
        if (location != null) {
            css = css.withPosition(new Vec3(location.getX(), location.getY(), location.getZ())).withRotation(new Vec2(location.getPitch(), location.getYaw()));
        }
        if (world == null && location != null) {
            world = location.getWorld();
        }
        if (world != null) {
            css = css.withLevel(((CraftWorld)world).getHandle());
        }
        if (callee instanceof Entity) {
            Entity e = (Entity)callee;
            css = css.withEntity(((CraftEntity)e).getHandle());
        }
        return new NativeProxyCommandSender_1_21_R5(css, caller, callee);
    }

    @Override
    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public final Object getSound(CommandContext<CommandSourceStack> cmdCtx, String key, ArgumentSubType subType) {
        ResourceLocation soundResource = ResourceLocationArgument.getId(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                Optional soundEvent = BuiltInRegistries.SOUND_EVENT.get(soundResource);
                if (soundEvent.isEmpty()) {
                    yield null;
                }
                yield CraftSound.minecraftToBukkit((SoundEvent)((SoundEvent)((Holder.Reference)soundEvent.get()).value()));
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.getNamespace() + ":" + soundResource.getPath()));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public SuggestionProvider<CommandSourceStack> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            default -> throw new IncompatibleClassChangeError();
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                ServerFunctionManager functionData = ((MinecraftServer)this.getMinecraftServer()).getFunctions();
                SharedSuggestionProvider.suggestResource((Iterable)functionData.getTagNames(), (SuggestionsBuilder)builder, (String)"#");
                return SharedSuggestionProvider.suggestResource((Iterable)functionData.getFunctionNames(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> (cmdCtx, builder) -> SharedSuggestionProvider.suggestResource(((MinecraftServer)this.getMinecraftServer()).getRecipeManager().getRecipes().stream().map(holder -> holder.id().location()), (SuggestionsBuilder)builder);
            case SuggestionProviders.SOUNDS -> (cmdCtx, builder) -> SharedSuggestionProvider.suggestResource((Stream)((CommandSourceStack)cmdCtx.getSource()).getAvailableSounds(), (SuggestionsBuilder)builder);
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> SharedSuggestionProvider.suggestResource(((MinecraftServer)this.getMinecraftServer()).getAdvancements().getAllAdvancements().stream().map(AdvancementHolder::id), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> {
                List<ResourceLocation> LootTableKeys = ((MinecraftServer)this.getMinecraftServer()).reloadableRegistries().lookup().lookupOrThrow(Registries.LOOT_TABLE).listElementIds().map(ResourceKey::location).toList();
                return SharedSuggestionProvider.suggestResource(LootTableKeys, (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> (cmdCtx, builder) -> SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.stream().filter(type -> type.isEnabled(((CommandSourceStack)cmdCtx.getSource()).enabledFeatures()) && type.canSummon()), (SuggestionsBuilder)builder, EntityType::getKey, EntityType::getDescription);
            case SuggestionProviders.POTION_EFFECTS -> (context, builder) -> SharedSuggestionProvider.suggestResource((Iterable)BuiltInRegistries.MOB_EFFECT.keySet(), (SuggestionsBuilder)builder);
        };
    }

    @Override
    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        List customFunctions = ((MinecraftServer)this.getMinecraftServer()).getFunctions().getTag(ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)key.getKey()));
        SimpleFunctionWrapper[] convertedCustomFunctions = new SimpleFunctionWrapper[customFunctions.size()];
        int index = 0;
        for (CommandFunction customFunction : customFunctions) {
            convertedCustomFunctions[index++] = this.convertFunction((CommandFunction<CommandSourceStack>)customFunction);
        }
        return convertedCustomFunctions;
    }

    @Override
    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (ResourceLocation resourceLocation : ((MinecraftServer)this.getMinecraftServer()).getFunctions().getTagNames()) {
            result.add(this.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public final Team getTeam(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        String teamName = TeamArgument.getTeam(cmdCtx, (String)key).getName();
        return Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
    }

    @Override
    public World getWorldForCSS(CommandSourceStack css) {
        return css.getLevel() == null ? null : css.getLevel().getWorld();
    }

    @Override
    public final void reloadDataPacks() {
        CommandAPI.logNormal("Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.ReloadableResources serverResources = ((MinecraftServer)this.getMinecraftServer()).resources;
        serverResources.managers().commands = ((MinecraftServer)this.getMinecraftServer()).getCommands();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.managers().getFunctionLibrary(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).getPackRepository().getSelectedIds());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).getWorldData().getDataConfiguration().dataPacks().getDisabled();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).getPackRepository().getAvailableIds()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        CompletionStage first = CompletableFuture.supplyAsync(() -> {
            PackRepository serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).getPackRepository();
            ArrayList<PackResources> packResources = new ArrayList<PackResources>();
            for (String packID : collection) {
                Pack pack = serverPackRepository.getPack(packID);
                if (pack == null) continue;
                packResources.add(pack.open());
            }
            return packResources;
        }).exceptionally(exception -> {
            CommandAPI.logException("Something went wrong while trying to collect resource packs!", exception);
            return ((MinecraftServer)this.getMinecraftServer()).getPackRepository().openAllSelected();
        });
        CompletionStage second = ((CompletableFuture)((CompletableFuture)first).thenCompose(packResources -> {
            MultiPackResourceManager resourceManager = new MultiPackResourceManager(PackType.SERVER_DATA, packResources);
            CompletableFuture simpleReloadInstance = SimpleReloadInstance.create((ResourceManager)resourceManager, (List)serverResources.managers().listeners(), (Executor)((MinecraftServer)this.getMinecraftServer()).executor, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(Unit.INSTANCE), (boolean)LogUtils.getLogger().isDebugEnabled()).done();
            return simpleReloadInstance.thenApply(x -> serverResources);
        })).exceptionally(exception -> {
            CommandAPI.logException("Something went wrong while trying to convert resource packs into ReloadableResources", exception);
            return ((MinecraftServer)this.getMinecraftServer()).resources;
        });
        CompletionStage third = ((CompletableFuture)((CompletableFuture)second).thenAcceptAsync(resources -> {
            ((MinecraftServer)this.getMinecraftServer()).resources.close();
            ((MinecraftServer)this.getMinecraftServer()).resources = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            if (minecraftServerSetSelected == null) {
                ((MinecraftServer)this.getMinecraftServer()).getPackRepository().setSelected(collection);
            } else {
                try {
                    minecraftServerSetSelected.invoke(((MinecraftServer)this.getMinecraftServer()).getPackRepository(), collection, true);
                }
                catch (Throwable e) {
                    CommandAPI.logException("Something went wrong while trying to invoke PackRepository#setSelected(Collection, boolean)", e);
                }
            }
            FeatureFlagSet enabledFeatures = ((MinecraftServer)this.getMinecraftServer()).getWorldData().getDataConfiguration().enabledFeatures();
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).getPackRepository().getSelectedIds();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).getPackRepository().getAvailableIds());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).getWorldData().setDataConfiguration(new WorldDataConfiguration(new DataPackConfig((List)enabledIDs, disabledIDs), enabledFeatures));
            ((MinecraftServer)this.getMinecraftServer()).resources.managers().updateStaticRegistryTags();
            ((MinecraftServer)this.getMinecraftServer()).resources.managers().getRecipeManager().finalizeRecipeLoading(enabledFeatures);
            ((MinecraftServer)this.getMinecraftServer()).getStructureManager().onResourceManagerReload((ResourceManager)((MinecraftServer)this.getMinecraftServer()).resources.resourceManager());
            minecraftServerFuelValues.set((MinecraftServer)this.getMinecraftServer(), FuelValues.vanillaBurnTimes((HolderLookup.Provider)((MinecraftServer)this.getMinecraftServer()).registries().compositeAccess(), (FeatureFlagSet)enabledFeatures));
        })).exceptionally(exception -> {
            CommandAPI.logException("Something went wrong while trying to load resources.", exception);
            return null;
        });
        if (((MinecraftServer)this.getMinecraftServer()).isSameThread()) {
            ((MinecraftServer)this.getMinecraftServer()).managedBlock(((CompletableFuture)third)::isDone);
        }
        try {
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal("Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString());
        }
    }

    @Override
    public Message generateMessageFromJson(String json) {
        return this.fromJson(json);
    }

    @Override
    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    @Override
    public ArgumentType<?> _ArgumentMobEffect() {
        return ResourceArgument.resource((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.MOB_EFFECT);
    }

    @Override
    public ArgumentType<?> _ArgumentEntitySummon() {
        return ResourceArgument.resource((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.ENTITY_TYPE);
    }

    @Override
    public CommandRegistrationStrategy<CommandSourceStack> createCommandRegistrationStrategy() {
        Class<?> bukkitCommandNode_bukkitBrigCommand;
        if (vanillaCommandDispatcherFieldExists) {
            return new SpigotCommandRegistration<CommandSourceStack>(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.getDispatcher(), (SimpleCommandMap)this.getPaper().getCommandMap(), () -> ((MinecraftServer)this.getMinecraftServer()).getCommands().getDispatcher(), command -> command instanceof VanillaCommandWrapper, node -> new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node), node -> node.getCommand() instanceof BukkitCommandWrapper);
        }
        try {
            bukkitCommandNode_bukkitBrigCommand = Class.forName("io.papermc.paper.command.brigadier.bukkit.BukkitCommandNode$BukkitBrigCommand");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Expected to find class", e);
        }
        return new PaperCommandRegistration<CommandSourceStack>(() -> ((MinecraftServer)this.getMinecraftServer()).getCommands().getDispatcher(), () -> {
            SimpleHelpMap helpMap = (SimpleHelpMap)Bukkit.getServer().getHelpMap();
            helpMap.clear();
            helpMap.initializeGeneralTopics();
            helpMap.initializeCommands();
        }, node -> bukkitCommandNode_bukkitBrigCommand.isInstance(node.getCommand()));
    }

    private static /* synthetic */ boolean lambda$getItemStackPredicate$7(Predicate predicate, org.bukkit.inventory.ItemStack item) {
        return predicate.test(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item));
    }

    static {
        boolean fieldExists;
        MethodHandle setSelected;
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            COMMAND_BUILD_CONTEXT = CommandBuildContext.simple((HolderLookup.Provider)server2.getServer().registryAccess(), (FeatureFlagSet)server2.getServer().getWorldData().getDataConfiguration().enabledFeatures());
        } else {
            COMMAND_BUILD_CONTEXT = null;
        }
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, "helpTopics", "helpTopics", Map.class);
        entitySelectorUsesSelector = CommandAPIHandler.getField(EntitySelector.class, "p", "usesSelector");
        serverFunctionLibraryDispatcher = CommandAPIHandler.getField(ServerFunctionLibrary.class, "h", "dispatcher");
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            setSelected = lookup.findVirtual(PackRepository.class, "setSelected", MethodType.methodType(Void.TYPE, Collection.class, Boolean.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            setSelected = null;
        }
        minecraftServerSetSelected = setSelected;
        try {
            MinecraftServer.class.getDeclaredField("vanillaCommandDispatcher");
            fieldExists = true;
        }
        catch (NoSuchFieldException | SecurityException e) {
            fieldExists = false;
        }
        vanillaCommandDispatcherFieldExists = fieldExists;
        minecraftServerFuelValues = SafeVarHandle.ofOrNull(MinecraftServer.class, "aE", "fuelValues", FuelValues.class);
    }
}

