/*
 * Decompiled with CFR 0.152.
 */
package software.axios.paper;

import java.io.File;
import java.util.Locale;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import software.axios.api.Axios;
import software.axios.api.AxiosApiPlugin;
import software.axios.libs.commandapi.CommandAPI;
import software.axios.libs.commandapi.CommandAPIBukkitConfig;
import software.axios.paper.api.AxiosApiProvider;
import software.axios.paper.commands.CommandAxios;
import software.axios.paper.configuration.Settings;
import software.axios.paper.i18n.Messages;
import software.axios.paper.util.ApiRegistrationUtil;

public class AxiosPlugin
extends JavaPlugin
implements AxiosApiPlugin {
    private Axios apiProvider;
    private static AxiosPlugin instance;

    public static AxiosPlugin instance() {
        return instance;
    }

    public void onLoad() {
        instance = this;
        CommandAPI.onLoad(new CommandAPIBukkitConfig(this).silentLogs(true));
    }

    public void onEnable() {
        this.apiProvider = new AxiosApiProvider(this);
        this.registerApi(this.apiProvider);
        this.reload();
        CommandAPI.onEnable();
        this.setupCommands();
        this.getLogger().info("Axios is enabled!");
    }

    public void onDisable() {
        CommandAxios.instance().unregister();
        CommandAPI.onDisable();
        ApiRegistrationUtil.unregisterProvider();
        this.getLogger().info("Axios is disabled!");
    }

    public Axios axiosApiProvider() {
        return this.apiProvider;
    }

    private void registerApi(Axios api) {
        ApiRegistrationUtil.registerProvider(this.apiProvider);
        this.getServer().getServicesManager().register(Axios.class, (Object)api, (Plugin)this, ServicePriority.Normal);
    }

    private void setupMessages() {
        this.axiosApiProvider().i18nManager().setup(this, Messages.class, Locale.GERMAN);
    }

    private void setupSettings() {
        this.axiosApiProvider().configManager().setup(this, Settings.class);
    }

    private void setupCommands() {
        CommandAxios.instance().register();
    }

    public void reload() {
        this.setupSettings();
        this.setupMessages();
    }

    public void debug(String message) {
        if (Settings.DEBUG.get().booleanValue()) {
            this.getLogger().info("[DEBUG] " + message);
        }
    }

    @Override
    @NotNull
    public File pluginFolder() {
        return this.getDataFolder();
    }

    @Override
    public void saveResources(String path, boolean replace) {
        this.saveResource(path, replace);
    }
}

