/*
 * Decompiled with CFR 0.152.
 */
package software.axios.paper.api.implementation;

import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import software.axios.api.platform.AxiosEntity;

public class PaperAxiosEntity
implements AxiosEntity {
    private final UUID uuid;
    private final String name;
    private final EntityType type;

    public PaperAxiosEntity(Object entity) {
        if (!(entity instanceof Entity)) {
            throw new IllegalArgumentException("entity must be an instance of org.bukkit.entity.Entity");
        }
        Entity bukkitEntity = (Entity)entity;
        this.uuid = bukkitEntity.getUniqueId();
        Component customName = bukkitEntity.customName();
        this.name = customName != null ? (String)MiniMessage.miniMessage().serialize(customName) : bukkitEntity.getName();
        this.type = bukkitEntity.getType();
    }

    @Override
    @NotNull
    public UUID uniqueId() {
        return this.uuid;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public String translationKey() {
        return this.type.translationKey();
    }
}

