/*
 * Decompiled with CFR 0.152.
 */
package software.axios.paper.api.implementation;

import java.util.Locale;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.axios.api.i18n.AxiosMessages;
import software.axios.api.i18n.MessagesInterface;
import software.axios.paper.api.implementation.PaperConfigManager;
import software.axios.paper.api.implementation.PaperI18nManager;

public class PaperAxiosMessages
implements AxiosMessages {
    private final Class<? extends MessagesInterface> callingClazz;
    private final String path;

    public PaperAxiosMessages(Class<? extends MessagesInterface> callingClazz, String path) {
        this.path = path;
        this.callingClazz = callingClazz;
    }

    @Override
    public @NonNull String toString(Locale locale) {
        return PaperI18nManager.getInstance().get(this.callingClazz, locale, this.path);
    }

    @Override
    public @NonNull String toString() {
        return this.toString(PaperConfigManager.getInstance().defaultLocale());
    }

    @Override
    public void sendTo(Audience audience, TagResolver placeholder) {
        MiniMessage mm = MiniMessage.miniMessage();
        Component parsed = mm.deserialize(this.toString(), placeholder);
        audience.forEachAudience(a -> {
            if (a instanceof Player) {
                Player player = (Player)a;
                Component component = mm.deserialize(this.toString(player.locale()), placeholder);
                player.sendMessage(component);
            } else {
                a.sendMessage(parsed);
            }
        });
    }

    @Override
    public void sendTo(Audience audience) {
        this.sendTo(audience, TagResolver.empty());
    }
}

