/*
 * Decompiled with CFR 0.152.
 */
package software.axios.paper.api.implementation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import net.kyori.adventure.util.UTF8ResourceBundleControl;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.axios.api.configuration.AxiosSettings;
import software.axios.api.configuration.SettingsInterface;
import software.axios.paper.AxiosPlugin;
import software.axios.paper.api.implementation.PaperConfigManager;

public class PaperAxiosSettings<T, R extends SettingsInterface>
implements AxiosSettings<T, R> {
    private final Class<R> callingClazz;
    private final String path;
    private final Class<T> type;
    private final T defaultValue;

    public PaperAxiosSettings(Class<R> callingClazz, String path, Class<T> type, T defaultValue) {
        this.callingClazz = callingClazz;
        this.path = path;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    @Override
    public @NonNull String path() {
        return this.path;
    }

    @Override
    public @NonNull List<String> comments() {
        String baseName = "comments.comments";
        ResourceBundle commentsBundle = ResourceBundle.getBundle(baseName, PaperConfigManager.getInstance().defaultLocale(), this.callingClazz.getClassLoader(), UTF8ResourceBundleControl.utf8ResourceBundleControl());
        ResourceBundle axiosMasterBundle = ResourceBundle.getBundle(baseName, PaperConfigManager.getInstance().defaultLocale(), AxiosPlugin.class.getClassLoader(), UTF8ResourceBundleControl.utf8ResourceBundleControl());
        assert (axiosMasterBundle.containsKey("axios.master"));
        String commentString = commentsBundle.containsKey(this.path) ? commentsBundle.getString(this.path) : "";
        String axiosMasterCommentString = axiosMasterBundle.getString("axios.master");
        axiosMasterCommentString = String.format(axiosMasterCommentString, this.type.getSimpleName(), this.defaultValue);
        ArrayList<String> comments = new ArrayList<String>(Arrays.asList(commentString.split("\\s*\\n\\s*")));
        if (comments.size() == 1 && ((String)comments.getFirst()).isEmpty()) {
            comments.set(0, axiosMasterCommentString);
        } else {
            comments.add("");
            comments.add(axiosMasterCommentString);
        }
        return comments;
    }

    @Override
    public @NonNull T get(R setting) {
        return PaperConfigManager.getInstance().get(this.callingClazz, setting);
    }

    @Override
    public @NonNull T defaultValue() {
        return this.defaultValue;
    }

    @Override
    public @NonNull Class<T> type() {
        return this.type;
    }
}

